/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.OperationTimeoutException;

public class MethodTimeoutProxy
implements InvocationHandler {
    private static final ExecutorService THREADPOOL = Executors.newCachedThreadPool();
    private final Object target;
    private final long timeoutMillis;

    public MethodTimeoutProxy(Object target, long timeoutMillis) {
        this.target = target;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this.target, args);
        }
        final Locale locale = CurrentLocale.get();
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object object;
                try {
                    CurrentLocale.set((Locale)locale);
                    object = method.invoke(MethodTimeoutProxy.this.target, args);
                }
                catch (Throwable throwable) {
                    try {
                        CurrentLocale.clear();
                        throw throwable;
                    }
                    catch (InvocationTargetException e) {
                        Throwable root = e.getCause();
                        if (root instanceof RuntimeException) {
                            throw (RuntimeException)root;
                        }
                        if (root instanceof Exception) {
                            throw (Exception)root;
                        }
                        if (root instanceof Error) {
                            throw (Error)root;
                        }
                        throw ConnectorException.wrap((Throwable)root);
                    }
                }
                CurrentLocale.clear();
                return object;
            }
        };
        try {
            FutureTask<Object> t = new FutureTask<Object>(callable);
            THREADPOOL.execute(t);
            return t.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            throw new OperationTimeoutException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
    }
}

