/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authroles.authentication;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.request.Request;

public abstract class AuthenticatedWebSession
extends AbstractAuthenticatedWebSession {
    private static final long serialVersionUID = 1L;
    private final AtomicBoolean signedIn = new AtomicBoolean(false);

    public static AuthenticatedWebSession get() {
        return (AuthenticatedWebSession)Session.get();
    }

    public AuthenticatedWebSession(Request request) {
        super(request);
    }

    public final boolean signIn(String username, String password) {
        boolean authenticated = this.authenticate(username, password);
        if (authenticated && this.signedIn.compareAndSet(false, true)) {
            this.bind();
        }
        return this.signedIn.get();
    }

    protected abstract boolean authenticate(String var1, String var2);

    protected final void signIn(boolean value) {
        this.signedIn.set(value);
    }

    @Override
    public final boolean isSignedIn() {
        return this.signedIn.get();
    }

    public void signOut() {
        this.signedIn.set(false);
    }

    public void invalidate() {
        this.signOut();
        super.invalidate();
    }
}

