/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import org.identityconnectors.common.Base64;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.GuardedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuardedStringDeserializer
extends JsonDeserializer<GuardedString> {
    private static final Logger LOG = LoggerFactory.getLogger(GuardedStringDeserializer.class);

    GuardedStringDeserializer() {
    }

    public GuardedString deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        Field field;
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        boolean readOnly = false;
        if (tree.has("readOnly")) {
            readOnly = tree.get("readOnly").asBoolean();
        }
        boolean disposed = false;
        if (tree.has("disposed")) {
            disposed = tree.get("disposed").asBoolean();
        }
        byte[] encryptedBytes = null;
        if (tree.has("encryptedBytes")) {
            encryptedBytes = Base64.decode((String)tree.get("encryptedBytes").asText());
        }
        String base64SHA1Hash = null;
        if (tree.has("base64SHA1Hash")) {
            base64SHA1Hash = tree.get("base64SHA1Hash").asText();
        }
        byte[] clearBytes = EncryptorFactory.getInstance().getDefaultEncryptor().decrypt(encryptedBytes);
        GuardedString dest = new GuardedString(new String(clearBytes).toCharArray());
        try {
            field = GuardedString.class.getDeclaredField("readOnly");
            field.setAccessible(true);
            field.setBoolean(dest, readOnly);
        }
        catch (Exception e) {
            LOG.error("Could not set field value to {}", (Object)readOnly, (Object)e);
        }
        try {
            field = GuardedString.class.getDeclaredField("disposed");
            field.setAccessible(true);
            field.setBoolean(dest, disposed);
        }
        catch (Exception e) {
            LOG.error("Could not set field value to {}", (Object)disposed, (Object)e);
        }
        if (base64SHA1Hash != null) {
            try {
                field = GuardedString.class.getDeclaredField("base64SHA1Hash");
                field.setAccessible(true);
                field.set(dest, base64SHA1Hash);
            }
            catch (Exception e) {
                LOG.error("Could not set field value to {}", (Object)base64SHA1Hash, (Object)e);
            }
        }
        return dest;
    }
}

