/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class VirAttrCacheValue {
    private final List<String> values;
    private Date creationDate = new Date();
    private Date lastAccessDate = new Date();

    public VirAttrCacheValue() {
        this.values = new ArrayList<String>();
    }

    public void setValues(Collection<Object> values) {
        this.values.clear();
        if (values != null) {
            for (Object value : values) {
                this.values.add(value.toString());
            }
        }
    }

    public Date getCreationDate() {
        if (this.creationDate != null) {
            return new Date(this.creationDate.getTime());
        }
        return null;
    }

    public void forceExpiring() {
        this.creationDate = new Date(0L);
    }

    public List<String> getValues() {
        return this.values;
    }

    public Date getLastAccessDate() {
        if (this.lastAccessDate != null) {
            return new Date(this.lastAccessDate.getTime());
        }
        return null;
    }

    public void setLastAccessDate(Date lastAccessDate) {
        this.lastAccessDate = lastAccessDate != null ? new Date(lastAccessDate.getTime()) : null;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.values);
        hash = 67 * hash + Objects.hashCode(this.creationDate);
        hash = 67 * hash + Objects.hashCode(this.lastAccessDate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirAttrCacheValue other = (VirAttrCacheValue)obj;
        if (!Objects.equals(this.values, other.values)) {
            return false;
        }
        if (!Objects.equals(this.creationDate, other.creationDate)) {
            return false;
        }
        return Objects.equals(this.lastAccessDate, other.lastAccessDate);
    }

    public String toString() {
        return "VirAttrCacheValue{values=" + this.values + ", creationDate=" + this.creationDate + ", lastAccessDate=" + this.lastAccessDate + '}';
    }
}

