/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.AttrTO;

@XmlRootElement(name="saml2LoginResponse")
@XmlType
public class SAML2LoginResponseTO
extends AbstractBaseBean {
    private static final long serialVersionUID = 794772343787258010L;
    private String nameID;
    private String sessionIndex;
    private Date authInstant;
    private Date notOnOrAfter;
    private String accessToken;
    private Date accessTokenExpiryTime;
    private String username;
    private final Set<AttrTO> attrs = new HashSet<AttrTO>();
    private String idp;
    private boolean sloSupported;
    private boolean selfReg;

    public String getNameID() {
        return this.nameID;
    }

    public void setNameID(String nameID) {
        this.nameID = nameID;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public Date getAuthInstant() {
        if (this.authInstant != null) {
            return new Date(this.authInstant.getTime());
        }
        return null;
    }

    public void setAuthInstant(Date authInstant) {
        this.authInstant = authInstant != null ? new Date(authInstant.getTime()) : null;
    }

    public Date getNotOnOrAfter() {
        if (this.notOnOrAfter != null) {
            return new Date(this.notOnOrAfter.getTime());
        }
        return null;
    }

    public void setNotOnOrAfter(Date notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter != null ? new Date(notOnOrAfter.getTime()) : null;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Date getAccessTokenExpiryTime() {
        return this.accessTokenExpiryTime;
    }

    public void setAccessTokenExpiryTime(Date accessTokenExpiryTime) {
        this.accessTokenExpiryTime = accessTokenExpiryTime;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public AttrTO getAttr(final String schema) {
        return (AttrTO)IterableUtils.find(this.attrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO object) {
                return object.getSchema().equals(schema);
            }
        });
    }

    @XmlElementWrapper(name="attrs")
    @XmlElement(name="attr")
    @JsonProperty(value="attrs")
    public Set<AttrTO> getAttrs() {
        return this.attrs;
    }

    public String getIdp() {
        return this.idp;
    }

    public void setIdp(String idp) {
        this.idp = idp;
    }

    public boolean isSloSupported() {
        return this.sloSupported;
    }

    public void setSloSupported(boolean sloSupported) {
        this.sloSupported = sloSupported;
    }

    public boolean isSelfReg() {
        return this.selfReg;
    }

    public void setSelfReg(boolean selfReg) {
        this.selfReg = selfReg;
    }
}

