/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti.spring;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.spring.SpringExpressionManager;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.workflow.activiti.spring.DomainProcessEngine;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;

public class DomainProcessEngineFactoryBean
implements FactoryBean<DomainProcessEngine>,
DisposableBean,
ApplicationContextAware {
    private ApplicationContext ctx;
    private DomainProcessEngine engine;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    public DomainProcessEngine getObject() throws Exception {
        if (this.engine == null) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>();
            for (Map.Entry entry : this.ctx.getBeansOfType(DataSource.class).entrySet()) {
                if (((String)entry.getKey()).startsWith("local")) continue;
                String domain = StringUtils.substringBefore((String)((String)entry.getKey()), (String)DataSource.class.getSimpleName());
                DataSource dataSource = (DataSource)entry.getValue();
                PlatformTransactionManager transactionManager = (PlatformTransactionManager)this.ctx.getBean(domain + "TransactionManager", PlatformTransactionManager.class);
                Object entityManagerFactory = this.ctx.getBean(domain + "EntityManagerFactory");
                SpringProcessEngineConfiguration conf = (SpringProcessEngineConfiguration)this.ctx.getBean(SpringProcessEngineConfiguration.class);
                conf.setDataSource(dataSource);
                conf.setTransactionManager(transactionManager);
                conf.setTransactionsExternallyManaged(true);
                conf.setJpaEntityManagerFactory(entityManagerFactory);
                if (conf.getBeans() == null) {
                    conf.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.ctx));
                }
                if (conf.getExpressionManager() == null) {
                    conf.setExpressionManager((ExpressionManager)new SpringExpressionManager(this.ctx, conf.getBeans()));
                }
                conf.setEnableSafeBpmnXml(true);
                engines.put(domain, conf.buildProcessEngine());
            }
            this.engine = new DomainProcessEngine(engines);
        }
        return this.engine;
    }

    public Class<DomainProcessEngine> getObjectType() {
        return DomainProcessEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.engine != null) {
            this.engine.close();
        }
    }
}

