/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.spring.ResourceWithFallbackLoader;
import org.apache.syncope.core.workflow.activiti.ActivitiDeployUtils;
import org.apache.syncope.core.workflow.activiti.spring.DomainProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivitiDefinitionLoader
implements SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ActivitiDefinitionLoader.class);
    @Resource(name="userWorkflowDef")
    private ResourceWithFallbackLoader userWorkflowDef;
    @Autowired
    private DomainProcessEngine dpEngine;

    public Integer getPriority() {
        return Integer.MIN_VALUE;
    }

    public void load() {
        byte[] wfDef = new byte[]{};
        try (InputStream wfIn = this.userWorkflowDef.getResource().getInputStream();){
            wfDef = IOUtils.toByteArray((InputStream)wfIn);
        }
        catch (IOException e) {
            LOG.error("While loading " + this.userWorkflowDef.getResource().getFilename(), (Throwable)e);
        }
        for (Map.Entry<String, ProcessEngine> entry : this.dpEngine.getEngines().entrySet()) {
            List processes = entry.getValue().getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("userWorkflow").list();
            LOG.debug("userWorkflow Activiti processes in repository: {}", (Object)processes);
            if (processes.isEmpty()) {
                entry.getValue().getRepositoryService().createDeployment().addInputStream(this.userWorkflowDef.getResource().getFilename(), (InputStream)new ByteArrayInputStream(wfDef)).deploy();
                ProcessDefinition procDef = (ProcessDefinition)entry.getValue().getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("userWorkflow").latestVersion().singleResult();
                ActivitiDeployUtils.deployModel(entry.getValue(), procDef);
                LOG.debug("Activiti Workflow definition loaded for domain {}", (Object)entry.getKey());
            }
            for (int i = 0; i < entry.getValue().getProcessEngineConfiguration().getIdBlockSize(); ++i) {
                ((SpringProcessEngineConfiguration)SpringProcessEngineConfiguration.class.cast(entry.getValue().getProcessEngineConfiguration())).getIdGenerator().getNextId();
            }
        }
    }
}

