/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.rest.api.service.RealmService;
import org.apache.syncope.core.logic.RealmLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RealmServiceImpl
extends AbstractServiceImpl
implements RealmService {
    @Autowired
    private RealmLogic logic;

    public List<RealmTO> list() {
        return this.list("");
    }

    public List<RealmTO> list(String fullPath) {
        return this.logic.list(StringUtils.prependIfMissing((String)fullPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    public Response create(String parentPath, RealmTO realmTO) {
        ProvisioningResult created = this.logic.create(StringUtils.prependIfMissing((String)parentPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]), realmTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(((RealmTO)created.getEntity()).getName()).build(new Object[0]);
        Response.ResponseBuilder builder = Response.created((URI)location).header("X-Syncope-Key", (Object)((RealmTO)created.getEntity()).getFullPath());
        return this.applyPreference(created, builder).build();
    }

    public Response update(RealmTO realmTO) {
        realmTO.setFullPath(StringUtils.prependIfMissing((String)realmTO.getFullPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        ProvisioningResult updated = this.logic.update(realmTO);
        return this.modificationResponse(updated);
    }

    public Response delete(String fullPath) {
        ProvisioningResult deleted = this.logic.delete(StringUtils.prependIfMissing((String)fullPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        return this.modificationResponse(deleted);
    }
}

