/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AssociationPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.patch.DeassociationPatch;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.lib.types.StatusPatchType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;

public abstract class AbstractAnyService<TO extends AnyTO, P extends AnyPatch>
extends AbstractServiceImpl
implements AnyService<TO> {
    protected abstract AnyDAO<?> getAnyDAO();

    protected abstract AbstractAnyLogic<TO, P> getAnyLogic();

    protected abstract P newPatch(String var1);

    public Set<AttrTO> read(String key, SchemaType schemaType) {
        Set result;
        TO any = this.read(key);
        switch (schemaType) {
            case DERIVED: {
                result = any.getDerAttrs();
                break;
            }
            case VIRTUAL: {
                result = any.getVirAttrs();
                break;
            }
            default: {
                result = any.getPlainAttrs();
            }
        }
        return result;
    }

    public AttrTO read(String key, SchemaType schemaType, String schema) {
        AttrTO result;
        TO any = this.read(key);
        switch (schemaType) {
            case DERIVED: {
                result = any.getDerAttr(schema);
                break;
            }
            case VIRTUAL: {
                result = any.getVirAttr(schema);
                break;
            }
            default: {
                result = any.getPlainAttr(schema);
            }
        }
        if (result == null) {
            throw new NotFoundException("Attribute for type " + schemaType + " and schema " + schema);
        }
        return result;
    }

    public TO read(String key) {
        return (TO)this.getAnyLogic().read(this.getActualKey(this.getAnyDAO(), key));
    }

    public PagedResult<TO> search(AnyQuery anyQuery) {
        String realm = StringUtils.prependIfMissing((String)anyQuery.getRealm(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        boolean isAssignableCond = StringUtils.isBlank((CharSequence)anyQuery.getFiql()) ? false : -1 != anyQuery.getFiql().indexOf(SpecialAttr.ASSIGNABLE.toString());
        SearchCond searchCond = StringUtils.isBlank((CharSequence)anyQuery.getFiql()) ? null : this.getSearchCond(anyQuery.getFiql(), realm);
        Pair result = this.getAnyLogic().search(searchCond, anyQuery.getPage().intValue(), anyQuery.getSize().intValue(), this.getOrderByClauses(anyQuery.getOrderBy()), isAssignableCond ? "/" : realm, anyQuery.getDetails().booleanValue());
        return this.buildPagedResult((List)result.getRight(), anyQuery.getPage(), anyQuery.getSize(), (Integer)result.getLeft());
    }

    protected Date findLastChange(String key) {
        Date lastChange = this.getAnyDAO().findLastChange(key);
        if (lastChange == null) {
            throw new NotFoundException("User, Group or Any Object for " + key);
        }
        return lastChange;
    }

    protected Response doUpdate(P anyPatch) {
        anyPatch.setKey(this.getActualKey(this.getAnyDAO(), anyPatch.getKey()));
        Date etagDate = this.findLastChange(anyPatch.getKey());
        this.checkETag(String.valueOf(etagDate.getTime()));
        ProvisioningResult updated = this.getAnyLogic().update(anyPatch, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    private void addUpdateOrReplaceAttr(String key, SchemaType schemaType, AttrTO attrTO, PatchOperation operation) {
        if (attrTO.getSchema() == null) {
            throw new NotFoundException("Must specify schema");
        }
        P patch = this.newPatch(key);
        switch (schemaType) {
            case VIRTUAL: {
                patch.getVirAttrs().add(attrTO);
                break;
            }
            case PLAIN: {
                patch.getPlainAttrs().add(((AttrPatch.Builder)new AttrPatch.Builder().operation(operation)).attrTO(attrTO).build());
                break;
            }
        }
        this.doUpdate(patch);
    }

    public Response update(String key, SchemaType schemaType, AttrTO attrTO) {
        String actualKey = this.getActualKey(this.getAnyDAO(), key);
        this.addUpdateOrReplaceAttr(actualKey, schemaType, attrTO, PatchOperation.ADD_REPLACE);
        return this.modificationResponse(this.read(actualKey, schemaType, attrTO.getSchema()));
    }

    public void delete(String key, SchemaType schemaType, String schema) {
        this.addUpdateOrReplaceAttr(this.getActualKey(this.getAnyDAO(), key), schemaType, new AttrTO.Builder().schema(schema).build(), PatchOperation.DELETE);
    }

    public Response delete(String key) {
        String actualKey = this.getActualKey(this.getAnyDAO(), key);
        Date etagDate = this.findLastChange(actualKey);
        this.checkETag(String.valueOf(etagDate.getTime()));
        ProvisioningResult deleted = this.getAnyLogic().delete(actualKey, this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }

    public Response deassociate(DeassociationPatch patch) {
        ProvisioningResult updated;
        Date etagDate = this.findLastChange(patch.getKey());
        this.checkETag(String.valueOf(etagDate.getTime()));
        switch (patch.getAction()) {
            case UNLINK: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().unlink(patch.getKey(), (Collection)patch.getResources()));
                break;
            }
            case UNASSIGN: {
                updated = this.getAnyLogic().unassign(patch.getKey(), (Collection)patch.getResources(), this.isNullPriorityAsync());
                break;
            }
            case DEPROVISION: {
                updated = this.getAnyLogic().deprovision(patch.getKey(), (Collection)patch.getResources(), this.isNullPriorityAsync());
                break;
            }
            default: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().read(patch.getKey()));
            }
        }
        BulkActionResult result = new BulkActionResult();
        if (patch.getAction() == ResourceDeassociationAction.UNLINK) {
            for (String resource : patch.getResources()) {
                result.getResults().put(resource, ((AnyTO)updated.getEntity()).getResources().contains(resource) ? BulkActionResult.Status.FAILURE : BulkActionResult.Status.SUCCESS);
            }
        } else {
            for (PropagationStatus propagationStatusTO : updated.getPropagationStatuses()) {
                result.getResults().put(propagationStatusTO.getResource(), BulkActionResult.Status.valueOf((String)propagationStatusTO.getStatus().toString()));
            }
        }
        return this.modificationResponse(result);
    }

    public Response associate(AssociationPatch patch) {
        ProvisioningResult updated;
        Date etagDate = this.findLastChange(patch.getKey());
        this.checkETag(String.valueOf(etagDate.getTime()));
        switch (patch.getAction()) {
            case LINK: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().link(patch.getKey(), (Collection)patch.getResources()));
                break;
            }
            case ASSIGN: {
                updated = this.getAnyLogic().assign(patch.getKey(), (Collection)patch.getResources(), patch.getValue() != null, (String)patch.getValue(), this.isNullPriorityAsync());
                break;
            }
            case PROVISION: {
                updated = this.getAnyLogic().provision(patch.getKey(), (Collection)patch.getResources(), patch.getValue() != null, (String)patch.getValue(), this.isNullPriorityAsync());
                break;
            }
            default: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().read(patch.getKey()));
            }
        }
        BulkActionResult result = new BulkActionResult();
        if (patch.getAction() == ResourceAssociationAction.LINK) {
            for (String resource : patch.getResources()) {
                result.getResults().put(resource, ((AnyTO)updated.getEntity()).getResources().contains(resource) ? BulkActionResult.Status.SUCCESS : BulkActionResult.Status.FAILURE);
            }
        } else {
            for (PropagationStatus propagationStatusTO : updated.getPropagationStatuses()) {
                result.getResults().put(propagationStatusTO.getResource(), BulkActionResult.Status.valueOf((String)propagationStatusTO.getStatus().toString()));
            }
        }
        return this.modificationResponse(result);
    }

    public Response bulk(BulkAction bulkAction) {
        AbstractAnyLogic<TO, P> logic = this.getAnyLogic();
        BulkActionResult result = new BulkActionResult();
        switch (bulkAction.getType()) {
            case MUSTCHANGEPASSWORD: {
                if (logic instanceof UserLogic) {
                    for (String key : bulkAction.getTargets()) {
                        try {
                            UserPatch userPatch = new UserPatch();
                            userPatch.setKey(key);
                            userPatch.setMustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)true)).build());
                            result.getResults().put(((UserTO)((UserLogic)logic).update(userPatch, false).getEntity()).getKey(), BulkActionResult.Status.SUCCESS);
                        }
                        catch (Exception e) {
                            LOG.error("Error performing delete for user {}", (Object)key, (Object)e);
                            result.getResults().put(key, BulkActionResult.Status.FAILURE);
                        }
                    }
                    break;
                }
                throw new BadRequestException();
            }
            case DELETE: {
                for (String key : bulkAction.getTargets()) {
                    try {
                        result.getResults().put(((AnyTO)logic.delete(key, this.isNullPriorityAsync()).getEntity()).getKey(), BulkActionResult.Status.SUCCESS);
                    }
                    catch (Exception e) {
                        LOG.error("Error performing delete for user {}", (Object)key, (Object)e);
                        result.getResults().put(key, BulkActionResult.Status.FAILURE);
                    }
                }
                break;
            }
            case SUSPEND: {
                if (logic instanceof UserLogic) {
                    for (String key : bulkAction.getTargets()) {
                        StatusPatch statusPatch = new StatusPatch.Builder().key(key).type(StatusPatchType.SUSPEND).onSyncope(true).build();
                        try {
                            result.getResults().put(((UserTO)((UserLogic)logic).status(statusPatch, this.isNullPriorityAsync()).getEntity()).getKey(), BulkActionResult.Status.SUCCESS);
                        }
                        catch (Exception e) {
                            LOG.error("Error performing suspend for user {}", (Object)key, (Object)e);
                            result.getResults().put(key, BulkActionResult.Status.FAILURE);
                        }
                    }
                    break;
                }
                throw new BadRequestException();
            }
            case REACTIVATE: {
                if (logic instanceof UserLogic) {
                    for (String key : bulkAction.getTargets()) {
                        StatusPatch statusPatch = new StatusPatch.Builder().key(key).type(StatusPatchType.REACTIVATE).onSyncope(true).build();
                        try {
                            result.getResults().put(((UserTO)((UserLogic)logic).status(statusPatch, this.isNullPriorityAsync()).getEntity()).getKey(), BulkActionResult.Status.SUCCESS);
                        }
                        catch (Exception e) {
                            LOG.error("Error performing reactivate for user {}", (Object)key, (Object)e);
                            result.getResults().put(key, BulkActionResult.Status.FAILURE);
                        }
                    }
                    break;
                }
                throw new BadRequestException();
            }
        }
        return this.modificationResponse(result);
    }
}

