/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.swagger.openapi.OpenApiConfiguration;
import org.apache.cxf.jaxrs.swagger.openapi.SwaggerToOpenApiConversionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@Provider
@PreMatching
public final class SyncopeSwaggerToOpenApiConversionFilter
implements ContainerRequestFilter,
WriterInterceptor {
    private static final String SWAGGER_PATH = "swagger.json";
    private static final String OPEN_API_PATH = "openapi.json";
    private static final String OPEN_API_PROPERTY = "openapi";
    private OpenApiConfiguration openApiConfig;
    private String openApiJsonPath = "openapi.json";

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        String path = reqCtx.getUriInfo().getPath();
        if (path.endsWith(this.openApiJsonPath)) {
            reqCtx.setRequestUri(URI.create(SWAGGER_PATH));
            JAXRSUtils.getCurrentMessage().getExchange().put((Object)OPEN_API_PROPERTY, (Object)Boolean.TRUE);
        }
    }

    public OpenApiConfiguration getOpenApiConfig() {
        return this.openApiConfig;
    }

    public void setOpenApiConfig(OpenApiConfiguration openApiConfig) {
        this.openApiConfig = openApiConfig;
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        if (this.isOpenApiRequested()) {
            OutputStream os = context.getOutputStream();
            CachedOutputStream cos = new CachedOutputStream();
            context.setOutputStream((OutputStream)cos);
            context.proceed();
            MessageContext ctx = this.createMessageContext();
            String swaggerJson = IOUtils.toString((InputStream)cos.getInputStream(), (Charset)StandardCharsets.UTF_8);
            String openApiJson = SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerJson((MessageContext)ctx, (String)swaggerJson, (OpenApiConfiguration)this.openApiConfig);
            JsonMapObjectReaderWriter readerWriter = new JsonMapObjectReaderWriter();
            JsonMapObject openapi = readerWriter.fromJsonToJsonObject(openApiJson);
            String basePath = StringUtils.substringBeforeLast((String)ctx.getHttpServletRequest().getRequestURI(), (String)"/");
            openapi.setProperty("servers", Arrays.asList(Collections.singletonMap("url", basePath)));
            os.write(readerWriter.toJson(openapi).getBytes(StandardCharsets.UTF_8));
            os.flush();
        } else {
            context.proceed();
        }
    }

    private MessageContext createMessageContext() {
        return (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
    }

    private boolean isOpenApiRequested() {
        return Objects.equals(Boolean.TRUE, JAXRSUtils.getCurrentMessage().getExchange().get((Object)OPEN_API_PROPERTY));
    }

    public void setOpenApiJsonPath(String openApiJsonPath) {
        this.openApiJsonPath = openApiJsonPath;
    }
}

