/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnIdObjectClassTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"Connectors"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="connectors")
public interface ConnectorService
extends JAXRSService {
    @GET
    @Path(value="bundles")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<ConnBundleTO> getBundles(@QueryParam(value="lang") String var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="key", paramType="path", dataType="string", value="Connector instance' key")})
    @POST
    @Path(value="{key}/supportedObjectClasses")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public List<ConnIdObjectClassTO> buildObjectClassInfo(@NotNull ConnInstanceTO var1, @QueryParam(value="includeSpecial") @DefaultValue(value="false") boolean var2);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ConnInstanceTO read(@NotNull @PathParam(value="key") String var1, @QueryParam(value="lang") String var2);

    @GET
    @Path(value="byResource/{resourceName}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ConnInstanceTO readByResource(@NotNull @PathParam(value="resourceName") String var1, @QueryParam(value="lang") String var2);

    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<ConnInstanceTO> list(@QueryParam(value="lang") String var1);

    @ApiResponses(value={@ApiResponse(code=201, message="ConnInstance successfully created", responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="UUID generated for the entity created"), @ResponseHeader(name="Location", response=String.class, description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull ConnInstanceTO var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="key", paramType="path", dataType="string", value="Connector instance' key")})
    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull ConnInstanceTO var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="check")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void check(@NotNull ConnInstanceTO var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="reload")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void reload();
}

