/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.dialog;

import com.googlecode.wicket.jquery.ui.panel.JQueryFeedbackPanel;
import com.googlecode.wicket.jquery.ui.widget.dialog.AbstractFormDialog;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButtons;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public abstract class InputDialog<T extends Serializable>
extends AbstractFormDialog<T> {
    private static final long serialVersionUID = 1L;
    private final FeedbackPanel feedback;
    private final Form<?> form;
    private IModel<String> labelModel;

    public InputDialog(String id, String title, String label) {
        this(id, title, label, (IModel<T>)new Model());
    }

    public InputDialog(String id, IModel<String> title, IModel<String> label) {
        this(id, title, label, (IModel<T>)new Model());
    }

    public InputDialog(String id, String title, String label, IModel<T> model) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)label)), model);
    }

    public InputDialog(String id, IModel<String> title, IModel<String> label, IModel<T> model) {
        super(id, title, model, true);
        this.labelModel = label;
        this.form = InputDialog.newForm("form");
        this.add(new Component[]{this.form});
        this.feedback = new JQueryFeedbackPanel("feedback");
        this.form.add(new Component[]{this.feedback});
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.form.add(new Component[]{this.newLabel("label", this.labelModel)});
        this.form.add(new Component[]{this.newTextField("input", this.getModel()).setRequired(this.isRequired())});
    }

    @Override
    protected void onOpen(IPartialPageRequestHandler handler) {
        super.onOpen(handler);
        handler.add(new Component[]{this.form});
    }

    @Override
    public final void onError(AjaxRequestTarget target) {
        target.add(new Component[]{this.feedback});
    }

    @Override
    protected void onDetach() {
        super.onDetach();
        this.labelModel.detach();
    }

    @Deprecated
    public IModel<String> getLabel() {
        return this.labelModel;
    }

    @Deprecated
    public void setLabel(IModel<String> label) {
        Args.notNull(label, (String)"label");
        this.labelModel = label;
    }

    @Override
    public Form<?> getForm() {
        return this.form;
    }

    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected List<DialogButton> getButtons() {
        return DialogButtons.OK_CANCEL.toList();
    }

    @Override
    public DialogButton getSubmitButton() {
        return this.findButton("OK");
    }

    private static Form<?> newForm(String id) {
        return new Form<Void>(id){
            private static final long serialVersionUID = 1L;

            protected boolean wantSubmitOnParentFormSubmit() {
                return false;
            }
        };
    }

    protected Component newLabel(String id, IModel<String> model) {
        return new Label(id, model);
    }

    protected FormComponent<T> newTextField(String id, IModel<T> model) {
        return new TextField(id, model);
    }
}

