/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicInitializer
implements InitializingBean,
BeanFactoryAware {
    private static final Logger LOG = LoggerFactory.getLogger(LogicInitializer.class);
    private DefaultListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Map loaderMap = this.beanFactory.getBeansOfType(SyncopeLoader.class);
        ArrayList loaders = new ArrayList(loaderMap.values());
        Collections.sort(loaders, new Comparator<SyncopeLoader>(){

            @Override
            public int compare(SyncopeLoader o1, SyncopeLoader o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
        ApplicationContextProvider.setBeanFactory((DefaultListableBeanFactory)this.beanFactory);
        LOG.debug("Starting initialization...");
        for (SyncopeLoader loader : loaders) {
            LOG.debug("Invoking {} with priority {}", (Object)AopUtils.getTargetClass((Object)loader).getName(), (Object)loader.getPriority());
            loader.load();
        }
        LOG.debug("Initialization completed");
    }
}

