/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewriteAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.logic.MemoryAppender;
import org.apache.syncope.core.logic.audit.AuditAppender;
import org.apache.syncope.core.logic.init.LoggerAccessor;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component
public class LoggerLoader
implements SyncopeLoader {
    @Autowired
    private DomainsHolder domainsHolder;
    @Autowired
    private LoggerAccessor loggerAccessor;
    @Autowired
    private ImplementationLookup implementationLookup;
    private final Map<String, MemoryAppender> memoryAppenders = new HashMap<String, MemoryAppender>();

    public Integer getPriority() {
        return 300;
    }

    public void load() {
        final LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        for (Map.Entry entry : ctx.getConfiguration().getAppenders().entrySet()) {
            if (!(entry.getValue() instanceof MemoryAppender)) continue;
            this.memoryAppenders.put((String)entry.getKey(), (MemoryAppender)((Object)entry.getValue()));
        }
        ColumnConfig[] columnConfigs = new ColumnConfig[]{ColumnConfig.newBuilder().setConfiguration(ctx.getConfiguration()).setName("EVENT_DATE").setEventTimestamp(true).build(), ColumnConfig.newBuilder().setUnicode(false).setConfiguration(ctx.getConfiguration()).setName("LOGGER_LEVEL").setPattern("%level").build(), ColumnConfig.newBuilder().setUnicode(false).setConfiguration(ctx.getConfiguration()).setName("LOGGER").setPattern("%logger").build(), ColumnConfig.newBuilder().setUnicode(false).setConfiguration(ctx.getConfiguration()).setName("MESSAGE").setPattern("%message").build(), ColumnConfig.newBuilder().setUnicode(false).setConfiguration(ctx.getConfiguration()).setName("THROWABLE").setPattern("%ex{full}").build()};
        ColumnMapping[] columnMappings = new ColumnMapping[]{};
        for (Map.Entry entry : this.domainsHolder.getDomains().entrySet()) {
            Appender appender = ctx.getConfiguration().getAppender("audit_for_" + (String)entry.getKey());
            if (appender == null) {
                appender = ((JdbcAppender.Builder)((JdbcAppender.Builder)JdbcAppender.newBuilder().withName("audit_for_" + (String)entry.getKey())).withIgnoreExceptions(false)).setConnectionSource((ConnectionSource)new DataSourceConnectionSource((String)entry.getKey(), (DataSource)entry.getValue())).setBufferSize(0).setTableName("SYNCOPEAUDIT").setColumnConfigs(columnConfigs).setColumnMappings(columnMappings).build();
                appender.start();
                ctx.getConfiguration().addAppender(appender);
            }
            LoggerConfig logConf = new LoggerConfig(AuditLoggerName.getAuditLoggerName((String)((String)entry.getKey())), null, false);
            logConf.addAppender(appender, Level.DEBUG, null);
            logConf.setLevel(Level.DEBUG);
            ctx.getConfiguration().addLogger(AuditLoggerName.getAuditLoggerName((String)((String)entry.getKey())), logConf);
            for (AuditAppender auditAppender : this.auditAppenders((String)entry.getKey())) {
                for (AuditLoggerName event : auditAppender.getEvents()) {
                    String domainAuditLoggerName = AuditLoggerName.getAuditEventLoggerName((String)((String)entry.getKey()), (String)event.toLoggerName());
                    LoggerConfig eventLogConf = ctx.getConfiguration().getLoggerConfig(domainAuditLoggerName);
                    boolean isRootLogConf = "".equals(eventLogConf.getName());
                    if (isRootLogConf) {
                        eventLogConf = new LoggerConfig(domainAuditLoggerName, null, false);
                    }
                    this.addAppenderToContext(ctx, auditAppender, eventLogConf);
                    eventLogConf.setLevel(Level.DEBUG);
                    if (!isRootLogConf) continue;
                    ctx.getConfiguration().addLogger(domainAuditLoggerName, eventLogConf);
                }
            }
            AuthContextUtils.execWithAuthContext((String)((String)entry.getKey()), (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                public Void exec() {
                    LoggerLoader.this.loggerAccessor.synchronizeLog4J(ctx);
                    return null;
                }
            });
        }
        ctx.updateLoggers();
    }

    public Map<String, MemoryAppender> getMemoryAppenders() {
        return this.memoryAppenders;
    }

    public List<AuditAppender> auditAppenders(String domain) throws BeansException {
        ArrayList<AuditAppender> auditAppenders = new ArrayList<AuditAppender>();
        for (Class clazz : this.implementationLookup.getAuditAppenderClasses()) {
            AuditAppender auditAppender;
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(clazz.getName())) {
                auditAppender = (AuditAppender)ApplicationContextProvider.getBeanFactory().getSingleton(clazz.getName());
            } else {
                auditAppender = (AuditAppender)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, true);
                auditAppender.setDomainName(domain);
                auditAppender.init();
            }
            auditAppenders.add(auditAppender);
        }
        return auditAppenders;
    }

    public void addAppenderToContext(LoggerContext ctx, AuditAppender auditAppender, LoggerConfig eventLogConf) {
        Appender targetAppender = ctx.getConfiguration().getAppender(auditAppender.getTargetAppenderName());
        if (targetAppender == null) {
            targetAppender = auditAppender.getTargetAppender();
        }
        targetAppender.start();
        ctx.getConfiguration().addAppender(targetAppender);
        if (auditAppender.isRewriteEnabled()) {
            RewriteAppender rewriteAppender = (RewriteAppender)ctx.getConfiguration().getAppender(auditAppender.getTargetAppenderName() + "_rewrite");
            if (rewriteAppender == null) {
                rewriteAppender = auditAppender.getRewriteAppender();
            }
            rewriteAppender.start();
            ctx.getConfiguration().addAppender((Appender)rewriteAppender);
            eventLogConf.addAppender((Appender)rewriteAppender, Level.DEBUG, null);
        } else {
            eventLogConf.addAppender(targetAppender, Level.DEBUG, null);
        }
    }

    private static class DataSourceConnectionSource
    extends AbstractConnectionSource {
        private final String description;
        private final DataSource dataSource;

        DataSourceConnectionSource(String domain, DataSource dataSource) {
            this.description = "dataSource{ domain=" + domain + ", value=" + dataSource + " }";
            this.dataSource = dataSource;
        }

        public Connection getConnection() throws SQLException {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }

        public String toString() {
            return this.description;
        }
    }
}

