/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class SyncopeLogic
extends AbstractLogic<AbstractBaseBean> {
    private static final Object MONITOR = new Object();
    private static PlatformInfo PLATFORM_INFO;
    private static SystemInfo SYSTEM_INFO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private SecurityQuestionDAO securityQuestionDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private GroupDataBinder groupDataBinder;
    @Resource(name="version")
    private String version;
    @Resource(name="buildNumber")
    private String buildNumber;
    @Autowired
    private ConnIdBundleManager bundleManager;
    @Autowired
    private PropagationTaskExecutor propagationTaskExecutor;
    @Autowired
    private AnyObjectWorkflowAdapter awfAdapter;
    @Autowired
    private UserWorkflowAdapter uwfAdapter;
    @Autowired
    private GroupWorkflowAdapter gwfAdapter;
    @Autowired
    private AnyObjectProvisioningManager aProvisioningManager;
    @Autowired
    private UserProvisioningManager uProvisioningManager;
    @Autowired
    private GroupProvisioningManager gProvisioningManager;
    @Autowired
    private VirAttrCache virAttrCache;
    @Autowired
    private PasswordGenerator passwordGenerator;
    @Autowired
    private AnySearchDAO anySearchDAO;
    @Autowired
    private ImplementationLookup implLookup;

    public boolean isSelfRegAllowed() {
        return (Boolean)this.confDAO.find("selfRegistration.allowed", (Object)false);
    }

    public boolean isPwdResetAllowed() {
        return (Boolean)this.confDAO.find("passwordReset.allowed", (Object)false);
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return (Boolean)this.confDAO.find("passwordReset.securityQuestion", (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public PlatformInfo platform() {
        Object object = MONITOR;
        synchronized (object) {
            if (PLATFORM_INFO == null) {
                PLATFORM_INFO = new PlatformInfo();
                PLATFORM_INFO.setVersion(this.version);
                PLATFORM_INFO.setBuildNumber(this.buildNumber);
                if (this.bundleManager.getLocations() != null) {
                    for (URI location : this.bundleManager.getLocations()) {
                        PLATFORM_INFO.getConnIdLocations().add(location.toASCIIString());
                    }
                }
                PLATFORM_INFO.setPropagationTaskExecutor(AopUtils.getTargetClass((Object)this.propagationTaskExecutor).getName());
                PLATFORM_INFO.setAnyObjectWorkflowAdapter(AopUtils.getTargetClass((Object)this.awfAdapter).getName());
                PLATFORM_INFO.setAnyObjectWorkflowAdapterSupportEdit(this.awfAdapter.supportsDefinitionEdit());
                PLATFORM_INFO.setUserWorkflowAdapter(AopUtils.getTargetClass((Object)this.uwfAdapter).getName());
                PLATFORM_INFO.setUserWorkflowAdapterSupportEdit(this.uwfAdapter.supportsDefinitionEdit());
                PLATFORM_INFO.setGroupWorkflowAdapter(AopUtils.getTargetClass((Object)this.gwfAdapter).getName());
                PLATFORM_INFO.setGroupWorkflowAdapterSupportEdit(this.gwfAdapter.supportsDefinitionEdit());
                PLATFORM_INFO.setAnyObjectProvisioningManager(AopUtils.getTargetClass((Object)this.aProvisioningManager).getName());
                PLATFORM_INFO.setUserProvisioningManager(AopUtils.getTargetClass((Object)this.uProvisioningManager).getName());
                PLATFORM_INFO.setGroupProvisioningManager(AopUtils.getTargetClass((Object)this.gProvisioningManager).getName());
                PLATFORM_INFO.setVirAttrCache(AopUtils.getTargetClass((Object)this.virAttrCache).getName());
                PLATFORM_INFO.setPasswordGenerator(AopUtils.getTargetClass((Object)this.passwordGenerator).getName());
                PLATFORM_INFO.setAnySearchDAO(AopUtils.getTargetClass((Object)this.anySearchDAO).getName());
                PLATFORM_INFO.getJwtSSOProviders().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.JWT_SSO_PROVIDER));
                PLATFORM_INFO.getReportletConfs().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.REPORTLET_CONF));
                PLATFORM_INFO.getAccountRules().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.ACCOUNT_RULE_CONF));
                PLATFORM_INFO.getPasswordRules().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.PASSWORD_RULE_CONF));
                PLATFORM_INFO.getItemTransformers().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.ITEM_TRANSFORMER));
                PLATFORM_INFO.getTaskJobs().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.TASKJOBDELEGATE));
                PLATFORM_INFO.getReconciliationFilterBuilders().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.RECONCILIATION_FILTER_BUILDER));
                PLATFORM_INFO.getLogicActions().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.LOGIC_ACTIONS));
                PLATFORM_INFO.getPropagationActions().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.PROPAGATION_ACTIONS));
                PLATFORM_INFO.getPullActions().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.PULL_ACTIONS));
                PLATFORM_INFO.getPushActions().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.PUSH_ACTIONS));
                PLATFORM_INFO.getPullCorrelationRules().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.PULL_CORRELATION_RULE));
                PLATFORM_INFO.getValidators().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.VALIDATOR));
                PLATFORM_INFO.getNotificationRecipientsProviders().addAll(this.implLookup.getClassNames(ImplementationLookup.Type.NOTIFICATION_RECIPIENTS_PROVIDER));
            }
            PLATFORM_INFO.setSelfRegAllowed(this.isSelfRegAllowed());
            PLATFORM_INFO.setPwdResetAllowed(this.isPwdResetAllowed());
            PLATFORM_INFO.setPwdResetRequiringSecurityQuestions(this.isPwdResetRequiringSecurityQuestions());
            PLATFORM_INFO.getEntitlements().clear();
            PLATFORM_INFO.getEntitlements().addAll(EntitlementsHolder.getInstance().getValues());
            AuthContextUtils.execWithAuthContext((String)AuthContextUtils.getDomain(), (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                public Void exec() {
                    PLATFORM_INFO.getAnyTypes().clear();
                    CollectionUtils.collect((Iterable)SyncopeLogic.this.anyTypeDAO.findAll(), (Transformer)EntityUtils.keyTransformer(), (Collection)PLATFORM_INFO.getAnyTypes());
                    PLATFORM_INFO.getUserClasses().clear();
                    CollectionUtils.collect((Iterable)SyncopeLogic.this.anyTypeDAO.findUser().getClasses(), (Transformer)EntityUtils.keyTransformer(), (Collection)PLATFORM_INFO.getUserClasses());
                    PLATFORM_INFO.getAnyTypeClasses().clear();
                    CollectionUtils.collect((Iterable)SyncopeLogic.this.anyTypeClassDAO.findAll(), (Transformer)EntityUtils.keyTransformer(), (Collection)PLATFORM_INFO.getAnyTypeClasses());
                    PLATFORM_INFO.getResources().clear();
                    CollectionUtils.collect((Iterable)SyncopeLogic.this.resourceDAO.findAll(), (Transformer)EntityUtils.keyTransformer(), (Collection)PLATFORM_INFO.getResources());
                    return null;
                }
            });
        }
        return PLATFORM_INFO;
    }

    private void initSystemInfo() {
        if (SYSTEM_INFO == null) {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            SYSTEM_INFO = new SystemInfo();
            try {
                SYSTEM_INFO.setHostname(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                LOG.error("Could not get host name", (Throwable)e);
            }
            SYSTEM_INFO.setOs(operatingSystemMXBean.getName() + " " + operatingSystemMXBean.getVersion() + " " + operatingSystemMXBean.getArch());
            SYSTEM_INFO.setAvailableProcessors(operatingSystemMXBean.getAvailableProcessors());
            SYSTEM_INFO.setJvm(runtimeMXBean.getVmName() + " " + System.getProperty("java.version") + " " + runtimeMXBean.getVmVendor());
            SYSTEM_INFO.setStartTime(runtimeMXBean.getStartTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void addLoadInstant(PayloadApplicationEvent<SystemInfo.LoadInstant> event) {
        Object object = MONITOR;
        synchronized (object) {
            this.initSystemInfo();
            SYSTEM_INFO.getLoad().add(event.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public SystemInfo system() {
        Object object = MONITOR;
        synchronized (object) {
            this.initSystemInfo();
        }
        return SYSTEM_INFO;
    }

    @PreAuthorize(value="isAuthenticated()")
    public NumbersInfo numbers() {
        NumbersInfo numbersInfo = new NumbersInfo();
        numbersInfo.setTotalUsers(this.userDAO.count());
        numbersInfo.getUsersByRealm().putAll(this.userDAO.countByRealm());
        numbersInfo.getUsersByStatus().putAll(this.userDAO.countByStatus());
        numbersInfo.setTotalGroups(this.groupDAO.count());
        numbersInfo.getGroupsByRealm().putAll(this.groupDAO.countByRealm());
        Map anyObjectNumbers = this.anyObjectDAO.countByType();
        Iterator itor = anyObjectNumbers.entrySet().iterator();
        for (int i = 0; i < 2 && itor.hasNext(); ++i) {
            Map.Entry entry = itor.next();
            if (i == 0) {
                numbersInfo.setAnyType1(((AnyType)entry.getKey()).getKey());
                numbersInfo.setTotalAny1((Integer)entry.getValue());
                numbersInfo.getAny1ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
                continue;
            }
            if (i != 1) continue;
            numbersInfo.setAnyType2(((AnyType)entry.getKey()).getKey());
            numbersInfo.setTotalAny2((Integer)entry.getValue());
            numbersInfo.getAny2ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
        }
        numbersInfo.setTotalResources(this.resourceDAO.count());
        numbersInfo.setTotalRoles(this.roleDAO.count());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.RESOURCE.name(), numbersInfo.getTotalResources() > 0);
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ACCOUNT_POLICY.name(), !this.policyDAO.find(AccountPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PASSWORD_POLICY.name(), !this.policyDAO.find(PasswordPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.NOTIFICATION.name(), !this.notificationDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PULL_TASK.name(), !this.taskDAO.findAll(TaskType.PULL).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.VIR_SCHEMA.name(), !this.virSchemaDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ANY_TYPE.name(), !anyObjectNumbers.isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.SECURITY_QUESTION.name(), !this.securityQuestionDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ROLE.name(), numbersInfo.getTotalRoles() > 0);
        return numbersInfo;
    }

    @PreAuthorize(value="isAuthenticated()")
    public Pair<Integer, List<GroupTO>> searchAssignableGroups(String realm, String term, int page, int size) {
        SearchCond searchCond;
        AssignableCond assignableCond = new AssignableCond();
        assignableCond.setRealmFullPath(realm);
        if (StringUtils.isNotBlank((CharSequence)term)) {
            AnyCond termCond = new AnyCond(AttributeCond.Type.ILIKE);
            termCond.setSchema("name");
            String termSearchableValue = term.startsWith("*") && !term.endsWith("*") ? term + "%" : (!term.startsWith("*") && term.endsWith("*") ? "%" + term : (term.startsWith("*") && term.endsWith("*") ? term : "%" + term + "%"));
            termCond.setExpression(termSearchableValue);
            searchCond = SearchCond.getAndCond((SearchCond)SearchCond.getLeafCond((AssignableCond)assignableCond), (SearchCond)SearchCond.getLeafCond((AttributeCond)termCond));
        } else {
            searchCond = SearchCond.getLeafCond((AssignableCond)assignableCond);
        }
        int count = this.searchDAO.count(SyncopeConstants.FULL_ADMIN_REALMS, searchCond, AnyTypeKind.GROUP);
        OrderByClause orderByClause = new OrderByClause();
        orderByClause.setField("name");
        orderByClause.setDirection(OrderByClause.Direction.ASC);
        List matching = this.searchDAO.search(SyncopeConstants.FULL_ADMIN_REALMS, searchCond, page, size, Collections.singletonList(orderByClause), AnyTypeKind.GROUP);
        List result = (List)CollectionUtils.collect((Iterable)matching, (Transformer)new Transformer<Group, GroupTO>(){

            @Transactional(readOnly=true)
            public GroupTO transform(Group input) {
                return SyncopeLogic.this.groupDataBinder.getGroupTO(input, false);
            }
        }, new ArrayList());
        return Pair.of((Object)count, (Object)result);
    }

    @PreAuthorize(value="isAuthenticated()")
    public TypeExtensionTO readTypeExtension(String groupName) {
        Group group = this.groupDAO.findByName(groupName);
        if (group == null) {
            throw new NotFoundException("Group " + groupName);
        }
        TypeExtension typeExt = group.getTypeExtension(this.anyTypeDAO.findUser());
        if (typeExt == null) {
            throw new NotFoundException("TypeExtension in " + groupName + " for users");
        }
        return this.groupDataBinder.getTypeExtensionTO(typeExt);
    }

    @Override
    protected AbstractBaseBean resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

