/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ResourceLogic
extends AbstractTransactionalLogic<ResourceTO> {
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private ResourceDataBinder binder;
    @Autowired
    private ConnInstanceDataBinder connInstanceDataBinder;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private ConnectorFactory connFactory;

    protected void securityChecks(Set<String> effectiveRealms, final String realm, String key) {
        boolean authorized = IterableUtils.matchesAny(effectiveRealms, (Predicate)new Predicate<String>(){

            public boolean evaluate(String ownedRealm) {
                return realm.startsWith(ownedRealm);
            }
        });
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, ExternalResource.class.getSimpleName(), key);
        }
    }

    @PreAuthorize(value="hasRole('RESOURCE_CREATE')")
    public ResourceTO create(ResourceTO resourceTO) {
        if (StringUtils.isBlank((CharSequence)resourceTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Resource key");
            throw sce;
        }
        ConnInstance connInstance = this.connInstanceDAO.authFind(resourceTO.getConnector());
        if (connInstance == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidExternalResource);
            sce.getElements().add("Connector " + resourceTO.getConnector());
            throw sce;
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_CREATE")), (String)connInstance.getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, connInstance.getAdminRealm().getFullPath(), null);
        if (this.resourceDAO.authFind(resourceTO.getKey()) != null) {
            throw new DuplicateException(resourceTO.getKey());
        }
        return this.binder.getResourceTO(this.resourceDAO.save(this.binder.create(resourceTO)));
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public ResourceTO update(ResourceTO resourceTO) {
        ExternalResource resource = this.resourceDAO.authFind(resourceTO.getKey());
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceTO.getKey() + "'");
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        return this.binder.getResourceTO(this.resourceDAO.save(this.binder.update(resource, resourceTO)));
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public void setLatestSyncToken(String key, String anyTypeKey) {
        Connector connector;
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        try {
            connector = this.connFactory.getConnector(resource);
        }
        catch (Exception e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidConnInstance);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if ("REALM".equals(anyTypeKey)) {
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provision not enabled for Resource '" + key + "'");
            }
            resource.getOrgUnit().setSyncToken(connector.getLatestSyncToken(resource.getOrgUnit().getObjectClass()));
        } else {
            AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
            if (anyType == null) {
                throw new NotFoundException("AnyType '" + anyTypeKey + "'");
            }
            Provision provision = resource.getProvision(anyType);
            if (provision == null) {
                throw new NotFoundException("Provision for AnyType '" + anyTypeKey + "' in Resource '" + key + "'");
            }
            provision.setSyncToken(connector.getLatestSyncToken(provision.getObjectClass()));
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        this.resourceDAO.save(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public void removeSyncToken(String key, String anyTypeKey) {
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        if ("REALM".equals(anyTypeKey)) {
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provision not enabled for Resource '" + key + "'");
            }
            resource.getOrgUnit().setSyncToken(null);
        } else {
            AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
            if (anyType == null) {
                throw new NotFoundException("AnyType '" + anyTypeKey + "'");
            }
            Provision provision = resource.getProvision(anyType);
            if (provision == null) {
                throw new NotFoundException("Provision for AnyType '" + anyTypeKey + "' in Resource '" + key + "'");
            }
            provision.setSyncToken(null);
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        this.resourceDAO.save(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_DELETE')")
    public ResourceTO delete(String key) {
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_DELETE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        ResourceTO resourceToDelete = this.binder.getResourceTO(resource);
        this.resourceDAO.delete(key);
        return resourceToDelete;
    }

    @PreAuthorize(value="hasRole('RESOURCE_READ')")
    @Transactional(readOnly=true)
    public ResourceTO read(String key) {
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        return this.binder.getResourceTO(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_LIST')")
    @Transactional(readOnly=true)
    public List<ResourceTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.resourceDAO.findAll(), (Transformer)new Transformer<ExternalResource, ResourceTO>(){

            public ResourceTO transform(ExternalResource input) {
                return ResourceLogic.this.binder.getResourceTO(input);
            }
        }, new ArrayList());
    }

    private Triple<ExternalResource, AnyType, Provision> connObjectInit(String resourceKey, String anyTypeKey) {
        ExternalResource resource = this.resourceDAO.authFind(resourceKey);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceKey + "'");
        }
        AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + anyTypeKey + "'");
        }
        Provision provision = resource.getProvision(anyType);
        if (provision == null) {
            throw new NotFoundException("Provision on resource '" + resourceKey + "' for type '" + anyTypeKey + "'");
        }
        return ImmutableTriple.of((Object)resource, (Object)anyType, (Object)provision);
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    @Transactional(readOnly=true)
    public ConnObjectTO readConnObject(String key, String anyTypeKey, String anyKey) {
        Any any;
        Triple<ExternalResource, AnyType, Provision> init = this.connObjectInit(key, anyTypeKey);
        Any any2 = ((AnyType)init.getMiddle()).getKind() == AnyTypeKind.USER ? this.userDAO.find(anyKey) : (any = ((AnyType)init.getMiddle()).getKind() == AnyTypeKind.ANY_OBJECT ? this.anyObjectDAO.find(anyKey) : this.groupDAO.find(anyKey));
        if (any == null) {
            throw new NotFoundException(init.getMiddle() + " " + anyKey);
        }
        MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem((Provision)((Provision)init.getRight()));
        if (connObjectKeyItem == null) {
            throw new NotFoundException("ConnObjectKey mapping for " + init.getMiddle() + " " + anyKey + " on resource '" + key + "'");
        }
        String connObjectKeyValue = this.mappingManager.getConnObjectKeyValue(any, (Provision)init.getRight());
        HashSet<MappingItem> linkinMappingItems = new HashSet<MappingItem>();
        for (VirSchema virSchema : this.virSchemaDAO.findByProvision((Provision)init.getRight())) {
            linkinMappingItems.add(virSchema.asLinkingMappingItem());
        }
        Iterator mapItems = IteratorUtils.chainedIterator(((Provision)init.getRight()).getMapping().getItems().iterator(), linkinMappingItems.iterator());
        Connector connector = this.connFactory.getConnector((ExternalResource)init.getLeft());
        ConnectorObject connectorObject = connector.getObject(((Provision)init.getRight()).getObjectClass(), AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue}), MappingUtils.buildOperationOptions((Iterator)mapItems));
        if (connectorObject == null) {
            throw new NotFoundException("Object " + connObjectKeyValue + " with class " + ((Provision)init.getRight()).getObjectClass() + " not found on resource " + key);
        }
        Set attributes = connectorObject.getAttributes();
        if (AttributeUtil.find((String)Uid.NAME, (Set)attributes) == null) {
            attributes.add(connectorObject.getUid());
        }
        if (AttributeUtil.find((String)Name.NAME, (Set)attributes) == null) {
            attributes.add(connectorObject.getName());
        }
        return ConnObjectUtils.getConnObjectTO((ConnectorObject)connectorObject);
    }

    @PreAuthorize(value="hasRole('RESOURCE_LIST_CONNOBJECT')")
    @Transactional(readOnly=true)
    public Pair<SearchResult, List<ConnObjectTO>> listConnObjects(String key, String anyTypeKey, final int size, String pagedResultsCookie, List<OrderByClause> orderBy) {
        OperationOptions options;
        ObjectClass objectClass;
        ExternalResource resource;
        if ("REALM".equals(anyTypeKey)) {
            resource = this.resourceDAO.authFind(key);
            if (resource == null) {
                throw new NotFoundException("Resource '" + key + "'");
            }
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provisioning for resource '" + key + "'");
            }
            objectClass = resource.getOrgUnit().getObjectClass();
            options = MappingUtils.buildOperationOptions(MappingUtils.getPropagationItems((List)resource.getOrgUnit().getItems()).iterator());
        } else {
            Triple<ExternalResource, AnyType, Provision> init = this.connObjectInit(key, anyTypeKey);
            resource = (ExternalResource)init.getLeft();
            objectClass = ((Provision)init.getRight()).getObjectClass();
            ((Provision)init.getRight()).getMapping().getItems();
            HashSet<MappingItem> linkinMappingItems = new HashSet<MappingItem>();
            for (VirSchema virSchema : this.virSchemaDAO.findByProvision((Provision)init.getRight())) {
                linkinMappingItems.add(virSchema.asLinkingMappingItem());
            }
            Iterator mapItems = IteratorUtils.chainedIterator(((Provision)init.getRight()).getMapping().getItems().iterator(), linkinMappingItems.iterator());
            options = MappingUtils.buildOperationOptions((Iterator)mapItems);
        }
        final ArrayList connObjects = new ArrayList();
        SearchResult searchResult = this.connFactory.getConnector(resource).search(objectClass, null, new SearchResultsHandler(){
            private int count;

            public boolean handle(ConnectorObject connectorObject) {
                connObjects.add(ConnObjectUtils.getConnObjectTO((ConnectorObject)connectorObject));
                ++this.count;
                return this.count < size;
            }

            public void handleResult(SearchResult sr) {
            }
        }, size, pagedResultsCookie, orderBy, options);
        return ImmutablePair.of((Object)searchResult, connObjects);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @Transactional(readOnly=true)
    public void check(ResourceTO resourceTO) {
        ConnInstance connInstance = this.connInstanceDAO.find(resourceTO.getConnector());
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + resourceTO.getConnector() + "'");
        }
        this.connFactory.createConnector(this.connFactory.buildConnInstanceOverride(this.connInstanceDataBinder.getConnInstanceTO(connInstance), (Collection)resourceTO.getConfOverride(), (Collection)(resourceTO.isOverrideCapabilities() ? resourceTO.getCapabilitiesOverride() : null))).test();
    }

    @Override
    protected ResourceTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ResourceTO)) continue;
                key = ((ResourceTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getResourceTO(this.resourceDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

