/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.cocoon.pipeline.NonCachingPipeline;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sax.component.XMLGenerator;
import org.apache.cocoon.sax.component.XMLSerializer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.syncope.common.lib.types.ReportExecStatus;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.cocoon.FopSerializer;
import org.apache.syncope.core.logic.cocoon.TextSerializer;
import org.apache.syncope.core.logic.cocoon.XSLTTransformer;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReportLogic
extends AbstractExecutableLogic<ReportTO> {
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private ReportDAO reportDAO;
    @Autowired
    private ReportExecDAO reportExecDAO;
    @Autowired
    private ReportDataBinder binder;
    @Autowired
    private EntityFactory entityFactory;

    @PreAuthorize(value="hasRole('REPORT_CREATE')")
    public ReportTO create(ReportTO reportTO) {
        Report report = (Report)this.entityFactory.newEntity(Report.class);
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobManager.register(report, null, ((Long)this.confDAO.find("tasks.interruptMaxRetries", (Object)1L)).longValue());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_UPDATE')")
    public ReportTO update(ReportTO reportTO) {
        Report report = this.reportDAO.find(reportTO.getKey());
        if (report == null) {
            throw new NotFoundException("Report " + reportTO.getKey());
        }
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobManager.register(report, null, ((Long)this.confDAO.find("tasks.interruptMaxRetries", (Object)1L)).longValue());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @Transactional(readOnly=true)
    public List<ReportTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.reportDAO.findAll(), (Transformer)new Transformer<Report, ReportTO>(){

            public ReportTO transform(Report input) {
                return ReportLogic.this.binder.getReportTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public ReportTO read(String key) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        return this.binder.getReportTO(report);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public ExecTO execute(String key, Date startAt, boolean dryRun) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        if (!report.isActive()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Report " + key + " is not active");
            throw sce;
        }
        try {
            this.jobManager.register(report, startAt, ((Long)this.confDAO.find("tasks.interruptMaxRetries", (Object)1L)).longValue());
            this.scheduler.getScheduler().triggerJob(JobNamer.getJobKey((Report)report));
        }
        catch (Exception e) {
            LOG.error("While executing report {}", (Object)report, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        ExecTO result = new ExecTO();
        result.setJobType(JobType.REPORT);
        result.setRefKey(report.getKey());
        result.setRefDesc(this.binder.buildRefDesc(report));
        result.setStart(new Date());
        result.setStatus(ReportExecStatus.STARTED.name());
        result.setMessage("Job fired; waiting for results...");
        return result;
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    public ReportExec getReportExec(String executionKey) {
        ReportExec reportExec = this.reportExecDAO.find(executionKey);
        if (reportExec == null) {
            throw new NotFoundException("Report execution " + executionKey);
        }
        if (!ReportExecStatus.SUCCESS.name().equals(reportExec.getStatus()) || reportExec.getExecResult() == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidReportExec);
            sce.getElements().add(reportExec.getExecResult() == null ? "No report data produced" : "Report did not run successfully");
            throw sce;
        }
        return reportExec;
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    public void exportExecutionResult(OutputStream os, ReportExec reportExec, ReportExecExportFormat format) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(reportExec.getExecResult());
             ZipInputStream zis = new ZipInputStream(bais);){
            zis.getNextEntry();
            NonCachingPipeline pipeline = new NonCachingPipeline();
            pipeline.addComponent((PipelineComponent)new XMLGenerator((InputStream)zis));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("status", reportExec.getStatus());
            parameters.put("message", reportExec.getMessage());
            parameters.put("start", reportExec.getStart());
            parameters.put("end", reportExec.getEnd());
            switch (format) {
                case HTML: {
                    XSLTTransformer xsl2html = new XSLTTransformer(new StreamSource(IOUtils.toInputStream((String)reportExec.getReport().getTemplate().getHTMLTemplate(), (Charset)StandardCharsets.UTF_8)));
                    xsl2html.setParameters(parameters);
                    pipeline.addComponent((PipelineComponent)xsl2html);
                    pipeline.addComponent((PipelineComponent)XMLSerializer.createXHTMLSerializer());
                    break;
                }
                case PDF: {
                    XSLTTransformer xsl2pdf = new XSLTTransformer(new StreamSource(IOUtils.toInputStream((String)reportExec.getReport().getTemplate().getFOTemplate(), (Charset)StandardCharsets.UTF_8)));
                    xsl2pdf.setParameters(parameters);
                    pipeline.addComponent((PipelineComponent)xsl2pdf);
                    pipeline.addComponent((PipelineComponent)new FopSerializer("application/pdf"));
                    break;
                }
                case RTF: {
                    XSLTTransformer xsl2rtf = new XSLTTransformer(new StreamSource(IOUtils.toInputStream((String)reportExec.getReport().getTemplate().getFOTemplate(), (Charset)StandardCharsets.UTF_8)));
                    xsl2rtf.setParameters(parameters);
                    pipeline.addComponent((PipelineComponent)xsl2rtf);
                    pipeline.addComponent((PipelineComponent)new FopSerializer("application/rtf"));
                    break;
                }
                case CSV: {
                    XSLTTransformer xsl2csv = new XSLTTransformer(new StreamSource(IOUtils.toInputStream((String)reportExec.getReport().getTemplate().getCSVTemplate(), (Charset)StandardCharsets.UTF_8)));
                    xsl2csv.setParameters(parameters);
                    pipeline.addComponent((PipelineComponent)xsl2csv);
                    pipeline.addComponent((PipelineComponent)new TextSerializer());
                    break;
                }
                default: {
                    pipeline.addComponent((PipelineComponent)XMLSerializer.createXMLSerializer());
                }
            }
            pipeline.setup(os);
            pipeline.execute();
            LOG.debug("Result of {} successfully exported as {}", (Object)reportExec, (Object)format);
        }
        catch (Exception e) {
            LOG.error("While exporting content", (Throwable)e);
        }
    }

    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ReportTO delete(String key) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        ReportTO deletedReport = this.binder.getReportTO(report);
        this.jobManager.unregister(report);
        this.reportDAO.delete(report);
        return deletedReport;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public Pair<Integer, List<ExecTO>> listExecutions(String key, int page, int size, List<OrderByClause> orderByClauses) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        Integer count = this.reportExecDAO.count(key);
        List result = (List)CollectionUtils.collect((Iterable)this.reportExecDAO.findAll(report, page, size, orderByClauses), (Transformer)new Transformer<ReportExec, ExecTO>(){

            public ExecTO transform(ReportExec reportExec) {
                return ReportLogic.this.binder.getExecTO(reportExec);
            }
        }, new ArrayList());
        return Pair.of((Object)count, (Object)result);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<ExecTO> listRecentExecutions(int max) {
        return (List)CollectionUtils.collect((Iterable)this.reportExecDAO.findRecent(max), (Transformer)new Transformer<ReportExec, ExecTO>(){

            public ExecTO transform(ReportExec reportExec) {
                return ReportLogic.this.binder.getExecTO(reportExec);
            }
        }, new ArrayList());
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ExecTO deleteExecution(String executionKey) {
        ReportExec reportExec = this.reportExecDAO.find(executionKey);
        if (reportExec == null) {
            throw new NotFoundException("Report execution " + executionKey);
        }
        ExecTO reportExecToDelete = this.binder.getExecTO(reportExec);
        this.reportExecDAO.delete(reportExec);
        return reportExecToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public BulkActionResult deleteExecutions(String key, Date startedBefore, Date startedAfter, Date endedBefore, Date endedAfter) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        BulkActionResult result = new BulkActionResult();
        for (ReportExec exec : this.reportExecDAO.findAll(report, startedBefore, startedAfter, endedBefore, endedAfter)) {
            try {
                this.reportExecDAO.delete(exec);
                result.getResults().put(String.valueOf(exec.getKey()), BulkActionResult.Status.SUCCESS);
            }
            catch (Exception e) {
                LOG.error("Error deleting execution {} of report {}", new Object[]{exec.getKey(), key, e});
                result.getResults().put(String.valueOf(exec.getKey()), BulkActionResult.Status.FAILURE);
            }
        }
        return result;
    }

    @Override
    protected Triple<JobType, String, String> getReference(JobKey jobKey) {
        String key = JobNamer.getReportKeyFromJobName((String)jobKey.getName());
        Report report = this.reportDAO.find(key);
        return report == null ? null : Triple.of((Object)JobType.REPORT, (Object)key, (Object)this.binder.buildRefDesc(report));
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<JobTO> listJobs() {
        return super.doListJobs(false);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public JobTO getJob(String key) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        JobTO jobTO = null;
        try {
            jobTO = this.getJobTO(JobNamer.getJobKey((Report)report), false);
        }
        catch (SchedulerException e) {
            LOG.error("Problems while retrieving scheduled job {}", (Object)JobNamer.getJobKey((Report)report), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (jobTO == null) {
            throw new NotFoundException("Job for report " + key);
        }
        return jobTO;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public void actionJob(String key, JobAction action) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        this.doActionJob(JobNamer.getJobKey((Report)report), action);
    }

    @Override
    protected ReportTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && ("create".equals(method.getName()) || "update".equals(method.getName()) || "delete".equals(method.getName()))) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ReportTO)) continue;
                key = ((ReportTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getReportTO(this.reportDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

