/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

abstract class AbstractJobLogic<T extends AbstractBaseBean>
extends AbstractTransactionalLogic<T> {
    @Autowired
    protected JobManager jobManager;
    @Autowired
    protected SchedulerFactoryBean scheduler;

    AbstractJobLogic() {
    }

    protected abstract Triple<JobType, String, String> getReference(JobKey var1);

    protected JobTO getJobTO(JobKey jobKey, boolean includeCustom) throws SchedulerException {
        JobTO jobTO = null;
        if (this.scheduler.getScheduler().checkExists(jobKey)) {
            JobDetail jobDetail;
            Triple<JobType, String, String> reference = this.getReference(jobKey);
            if (reference != null) {
                jobTO = new JobTO();
                jobTO.setType((JobType)reference.getLeft());
                jobTO.setRefKey((String)reference.getMiddle());
                jobTO.setRefDesc((String)reference.getRight());
            } else if (!(!includeCustom || TaskJob.class.isAssignableFrom((jobDetail = this.scheduler.getScheduler().getJobDetail(jobKey)).getJobClass()) || ReportJob.class.isAssignableFrom(jobDetail.getJobClass()) || SystemLoadReporterJob.class.isAssignableFrom(jobDetail.getJobClass()) || NotificationJob.class.isAssignableFrom(jobDetail.getJobClass()))) {
                jobTO = new JobTO();
                jobTO.setType(JobType.CUSTOM);
                jobTO.setRefKey(jobKey.getName());
                jobTO.setRefDesc(jobDetail.getJobClass().getName());
            }
            if (jobTO != null) {
                List jobTriggers = this.scheduler.getScheduler().getTriggersOfJob(jobKey);
                if (jobTriggers.isEmpty()) {
                    jobTO.setScheduled(false);
                } else {
                    jobTO.setScheduled(true);
                    jobTO.setStart(((Trigger)jobTriggers.get(0)).getStartTime());
                }
                jobTO.setRunning(this.jobManager.isRunning(jobKey));
                jobTO.setStatus("UNKNOWN");
                if (jobTO.isRunning()) {
                    try {
                        Object job = ApplicationContextProvider.getBeanFactory().getBean(jobKey.getName());
                        if (job instanceof AbstractInterruptableJob && ((AbstractInterruptableJob)job).getDelegate() != null) {
                            jobTO.setStatus(((AbstractInterruptableJob)job).getDelegate().currentStatus());
                        }
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        LOG.warn("Could not find job {} implementation", (Object)jobKey, (Object)e);
                    }
                }
            }
        }
        return jobTO;
    }

    protected List<JobTO> doListJobs(boolean includeCustom) {
        ArrayList<JobTO> jobTOs = new ArrayList<JobTO>();
        try {
            for (JobKey jobKey : this.scheduler.getScheduler().getJobKeys(GroupMatcher.jobGroupEquals((String)"DEFAULT"))) {
                JobTO jobTO = this.getJobTO(jobKey, includeCustom);
                if (jobTO == null) continue;
                jobTOs.add(jobTO);
            }
        }
        catch (SchedulerException e) {
            LOG.debug("Problems while retrieving scheduled jobs", (Throwable)e);
        }
        return jobTOs;
    }

    protected void doActionJob(JobKey jobKey, JobAction action) {
        try {
            if (this.scheduler.getScheduler().checkExists(jobKey)) {
                switch (action) {
                    case START: {
                        this.scheduler.getScheduler().triggerJob(jobKey);
                        break;
                    }
                    case STOP: {
                        this.scheduler.getScheduler().interrupt(jobKey);
                        break;
                    }
                    case DELETE: {
                        this.scheduler.getScheduler().deleteJob(jobKey);
                        break;
                    }
                }
            } else {
                LOG.warn("Could not find job {}", (Object)jobKey);
            }
        }
        catch (SchedulerException e) {
            LOG.debug("Problems during {} operation on job {}", new Object[]{action.toString(), jobKey, e});
        }
    }
}

