/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;

public class PreparedStatementManagerImpl
implements PreparedStatementManager {
    private static final Localizer _loc = Localizer.forPackage(PreparedStatementManagerImpl.class);
    protected final JDBCStore _store;
    protected final Connection _conn;
    protected final DBDictionary _dict;
    protected transient Log _log = null;
    protected final Collection<Exception> _exceptions = new LinkedList<Exception>();

    public PreparedStatementManagerImpl(JDBCStore store, Connection conn) {
        this._store = store;
        this._dict = store.getDBDictionary();
        this._conn = conn;
        if (store.getConfiguration() != null) {
            this._log = store.getConfiguration().getLog("openjpa.jdbc.JDBC");
        }
    }

    @Override
    public Collection<Exception> getExceptions() {
        return this._exceptions;
    }

    @Override
    public void flush(RowImpl row) {
        try {
            if (!row.isFlushed()) {
                this.flushInternal(row);
            }
        }
        catch (SQLException se) {
            this._exceptions.add((Exception)((Object)SQLExceptions.getStore(se, this._dict)));
        }
        catch (OpenJPAException ke) {
            this._exceptions.add((Exception)((Object)ke));
        }
    }

    protected void flushInternal(RowImpl row) throws SQLException {
        this.flushAndUpdate(row);
    }

    protected void flushAndUpdate(RowImpl row) throws SQLException {
        Column[] autoAssign = this.getAutoAssignColumns(row);
        String[] autoAssignColNames = this.getAutoAssignColNames(autoAssign, row);
        String sql = row.getSQL(this._dict);
        PreparedStatement stmnt = this.prepareStatement(sql, autoAssignColNames);
        if (stmnt != null) {
            row.flush(stmnt, this._dict, this._store);
        }
        try {
            int count = this.executeUpdate(stmnt, sql, row);
            if (count != 1) {
                this.logSQLWarnings(stmnt);
                Object failed = row.getFailedObject();
                if (failed != null) {
                    this._exceptions.add((Exception)new OptimisticException(failed));
                } else if (row.getAction() == 1) {
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(count), (Object)sql).getMessage());
                }
            }
            if (autoAssignColNames != null) {
                this.populateAutoAssignCols(stmnt, autoAssign, autoAssignColNames, row);
            } else {
                ClassMapping meta;
                StateManagerImpl sm = (StateManagerImpl)row.getPrimaryKey();
                if (sm != null && this.hasGeneratedKey(meta = (ClassMapping)sm.getMetaData())) {
                    sm.setObjectId(ApplicationIds.create((PersistenceCapable)sm.getPersistenceCapable(), (ClassMetaData)meta));
                }
            }
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, row.getFailedObject(), this._dict);
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    private boolean hasGeneratedKey(ClassMapping meta) {
        FieldMapping[] pks = meta.getPrimaryKeyFieldMappings();
        for (int i = 0; i < pks.length; ++i) {
            ClassMapping pkMeta = pks[i].getTypeMapping();
            if (pkMeta != null) {
                return this.hasGeneratedKey(pkMeta);
            }
            if (pks[i].getValueStrategy() != 3) continue;
            return true;
        }
        return false;
    }

    protected List<Object> populateAutoAssignCols(PreparedStatement stmnt, Column[] autoAssign, DBIdentifier[] autoAssignColNames, RowImpl row) throws SQLException {
        List<Object> vals = null;
        if (this._dict.supportsGetGeneratedKeys.booleanValue()) {
            vals = this.getGeneratedKeys(stmnt, autoAssignColNames);
        }
        this.setObjectId(vals, autoAssign, autoAssignColNames, row);
        return vals;
    }

    protected List<Object> populateAutoAssignCols(PreparedStatement stmnt, Column[] autoAssign, String[] autoAssignColNames, RowImpl row) throws SQLException {
        return this.populateAutoAssignCols(stmnt, autoAssign, DBIdentifier.toArray(autoAssignColNames, DBIdentifier.DBIdentifierType.COLUMN), row);
    }

    protected void setObjectId(List vals, Column[] autoAssign, String[] autoAssignColNames, RowImpl row) throws SQLException {
        this.setObjectId(vals, autoAssign, DBIdentifier.toArray(autoAssignColNames, DBIdentifier.DBIdentifierType.COLUMN), row);
    }

    protected void setObjectId(List vals, Column[] autoAssign, DBIdentifier[] autoAssignColNames, RowImpl row) throws SQLException {
        OpenJPAStateManager sm = row.getPrimaryKey();
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        Object val = null;
        for (int i = 0; i < autoAssign.length; ++i) {
            val = this._dict.supportsGetGeneratedKeys != false && vals != null && vals.size() > 0 ? (Object)vals.get(i) : this._dict.getGeneratedKey(autoAssign[i], this._conn);
            mapping.assertJoinable(autoAssign[i]).setAutoAssignedValue(sm, this._store, autoAssign[i], val);
        }
        sm.setObjectId(ApplicationIds.create((PersistenceCapable)sm.getPersistenceCapable(), (ClassMetaData)mapping));
    }

    protected List<Object> getGeneratedKeys(PreparedStatement stmnt, String[] autoAssignColNames) throws SQLException {
        return this.getGeneratedKeys(stmnt, DBIdentifier.toArray(autoAssignColNames, DBIdentifier.DBIdentifierType.COLUMN));
    }

    protected List<Object> getGeneratedKeys(PreparedStatement stmnt, DBIdentifier[] autoAssignColNames) throws SQLException {
        ResultSet rs = stmnt.getGeneratedKeys();
        ArrayList<Object> vals = new ArrayList<Object>();
        while (rs.next()) {
            for (int i = 0; i < autoAssignColNames.length; ++i) {
                vals.add(rs.getObject(i + 1));
            }
        }
        rs.close();
        return vals;
    }

    protected Column[] getAutoAssignColumns(RowImpl row) {
        Column[] autoAssign = null;
        if (row.getAction() == 1) {
            autoAssign = row.getTable().getAutoAssignedColumns();
        }
        return autoAssign;
    }

    protected String[] getAutoAssignColNames(Column[] autoAssign, RowImpl row) {
        String[] autoAssignColNames = null;
        if (autoAssign != null && autoAssign.length > 0 && row.getPrimaryKey() != null) {
            autoAssignColNames = new String[autoAssign.length];
            for (int i = 0; i < autoAssign.length; ++i) {
                autoAssignColNames[i] = this._dict.convertSchemaCase(autoAssign[i].getIdentifier());
            }
        }
        return autoAssignColNames;
    }

    @Override
    public void flush() {
    }

    protected int executeUpdate(PreparedStatement stmnt, String sql, RowImpl row) throws SQLException {
        return stmnt.executeUpdate();
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, null);
    }

    protected PreparedStatement prepareStatement(String sql, String[] autoAssignColNames) throws SQLException {
        if (autoAssignColNames != null && this._dict.supportsGetGeneratedKeys.booleanValue()) {
            return this._conn.prepareStatement(sql, autoAssignColNames);
        }
        return this._conn.prepareStatement(sql);
    }

    protected void logSQLWarnings(PreparedStatement stmt) {
        this.logSQLWarnings((Statement)stmt);
    }

    protected void logSQLWarnings(Statement stmt) {
        if (stmt != null && this._log != null && this._log.isTraceEnabled()) {
            try {
                for (SQLWarning warn = stmt.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                    this._log.trace((Object)_loc.get("sql-warning", (Object)warn.getMessage()));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

