/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnitItem;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPushResultHandler;
import org.apache.syncope.core.provisioning.java.job.AfterHandlingJob;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractRealmResultHandler;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultRealmPushResultHandler
extends AbstractRealmResultHandler<PushTask, PushActions>
implements RealmPushResultHandler {
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private SchedulerFactoryBean scheduler;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean handle(String realmKey) {
        Realm realm = null;
        try {
            realm = this.realmDAO.find(realmKey);
            this.doHandle(realm);
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(realm == null ? null : "REALM");
            result.setStatus(ProvisioningReport.Status.IGNORE);
            result.setKey(realmKey);
            this.profile.getResults().add(result);
            LOG.warn("Ignoring during push", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Push failed", (Throwable)e);
            return false;
        }
    }

    private void reportPropagation(ProvisioningReport result, PropagationReporter reporter) {
        if (!reporter.getStatuses().isEmpty()) {
            result.setStatus(this.toProvisioningReportStatus(((PropagationStatus)reporter.getStatuses().get(0)).getStatus()));
            result.setMessage(((PropagationStatus)reporter.getStatuses().get(0)).getFailureReason());
        }
    }

    private Realm update(RealmTO realmTO, ProvisioningReport result) {
        Realm realm = this.realmDAO.findByFullPath(realmTO.getFullPath());
        PropagationByResource propByRes = this.binder.update(realm, realmTO);
        realm = this.realmDAO.save(realm);
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.createTasks(realm, propByRes, null), false);
        this.reportPropagation(result, reporter);
        return realm;
    }

    private void deprovision(Realm realm, ProvisioningReport result) {
        ArrayList noPropResources = new ArrayList(realm.getResourceKeys());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, (Collection)realm.getResourceKeys());
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.createTasks(realm, propByRes, noPropResources), false);
        this.reportPropagation(result, reporter);
    }

    private void provision(Realm realm, ProvisioningReport result) {
        ArrayList noPropResources = new ArrayList(realm.getResourceKeys());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, ((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.createTasks(realm, propByRes, noPropResources), false);
        this.reportPropagation(result, reporter);
    }

    private void link(Realm realm, boolean unlink, ProvisioningReport result) {
        RealmTO realmTO = this.binder.getRealmTO(realm, true);
        if (unlink) {
            realmTO.getResources().remove(((PushTask)this.profile.getTask()).getResource().getKey());
        } else {
            realmTO.getResources().add(((PushTask)this.profile.getTask()).getResource().getKey());
        }
        this.update(realmTO, result);
    }

    private void unassign(Realm realm, ProvisioningReport result) {
        RealmTO realmTO = this.binder.getRealmTO(realm, true);
        realmTO.getResources().remove(((PushTask)this.profile.getTask()).getResource().getKey());
        this.deprovision(this.update(realmTO, result), result);
    }

    private void assign(Realm realm, ProvisioningReport result) {
        RealmTO realmTO = this.binder.getRealmTO(realm, true);
        realmTO.getResources().add(((PushTask)this.profile.getTask()).getResource().getKey());
        this.provision(this.update(realmTO, result), result);
    }

    protected ConnectorObject getRemoteObject(ObjectClass objectClass, String connObjectKey, String connObjectKeyValue, Iterator<? extends Item> iterator) {
        ConnectorObject obj = null;
        try {
            obj = this.profile.getConnector().getObject(objectClass, AttributeBuilder.build((String)connObjectKey, (Object[])new Object[]{connObjectKeyValue}), MappingUtils.buildOperationOptions(iterator));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("While resolving {}", (Object)connObjectKeyValue, (Object)ignore);
        }
        return obj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doHandle(Realm realm) throws JobExecutionException {
        HashMap<String, Object> jobMap;
        ProvisioningReport result = new ProvisioningReport();
        this.profile.getResults().add(result);
        result.setKey(realm.getKey());
        result.setAnyType("REALM");
        result.setName(realm.getFullPath());
        LOG.debug("Propagating Realm with key {} towards {}", (Object)realm.getKey(), (Object)((PushTask)this.profile.getTask()).getResource());
        Exception output = null;
        AuditElements.Result resultStatus = null;
        OrgUnit orgUnit = ((PushTask)this.profile.getTask()).getResource().getOrgUnit();
        OrgUnitItem connObjectKey = orgUnit.getConnObjectKeyItem();
        String connObjecKeyValue = this.mappingManager.getConnObjectKeyValue(realm, orgUnit);
        ConnectorObject beforeObj = null;
        if (connObjectKey == null || connObjecKeyValue == null) {
            LOG.debug("OrgUnitItem {} or its value {} are null", (Object)connObjectKey, (Object)connObjecKeyValue);
        } else {
            beforeObj = this.getRemoteObject(orgUnit.getObjectClass(), connObjectKey.getExtAttrName(), connObjecKeyValue, orgUnit.getItems().iterator());
        }
        if (this.profile.isDryRun()) {
            if (beforeObj == null) {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
            } else {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            return;
        }
        String operation = beforeObj == null ? UnmatchingRule.toEventName((UnmatchingRule)((PushTask)this.profile.getTask()).getUnmatchingRule()) : MatchingRule.toEventName((MatchingRule)((PushTask)this.profile.getTask()).getMatchingRule());
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuditElements.EventCategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        boolean auditRequested = this.auditManager.auditRequested(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        try {
            if (beforeObj == null) {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
                switch (((PushTask)this.profile.getTask()).getUnmatchingRule()) {
                    case ASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeAssign(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.assign(realm, result);
                        break;
                    }
                    case PROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeProvision(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.provision(realm, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(realm, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", (Object)realm);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            } else {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
                switch (((PushTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.update(this.binder.getRealmTO(realm, true), result);
                        break;
                    }
                    case DEPROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.deprovision(realm, result);
                        break;
                    }
                    case UNASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.unassign(realm, result);
                        break;
                    }
                    case LINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(realm, false, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(realm, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", (Object)realm);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            }
            for (PushActions action : this.profile.getActions()) {
                action.after(this.profile, (Entity)realm, result);
            }
            if (result.getStatus() == null) {
                result.setStatus(ProvisioningReport.Status.SUCCESS);
            }
            resultStatus = AuditElements.Result.SUCCESS;
            if (connObjectKey != null && connObjecKeyValue != null) {
                output = this.getRemoteObject(orgUnit.getObjectClass(), connObjectKey.getExtAttrName(), connObjecKeyValue, orgUnit.getItems().iterator());
            }
            if (!notificationsAvailable) {
                if (!auditRequested) return;
            }
            jobMap = new HashMap<String, Object>();
        }
        catch (IgnoreProvisionException e) {
            try {
                throw e;
                catch (Exception e2) {
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                    resultStatus = AuditElements.Result.FAILURE;
                    output = e2;
                    LOG.warn("Error pushing {} towards {}", new Object[]{realm, ((PushTask)this.profile.getTask()).getResource(), e2});
                    Iterator iterator = this.profile.getActions().iterator();
                    while (iterator.hasNext()) {
                        PushActions action = (PushActions)iterator.next();
                        action.onError(this.profile, (Entity)realm, result, e2);
                    }
                    throw new JobExecutionException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (!notificationsAvailable) {
                    if (!auditRequested) throw throwable;
                }
                HashMap<String, Object> jobMap2 = new HashMap<String, Object>();
                jobMap2.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{realm}));
                AfterHandlingJob.schedule(this.scheduler, jobMap2);
                throw throwable;
            }
        }
        jobMap.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{realm}));
        AfterHandlingJob.schedule(this.scheduler, jobMap);
    }

    private ResourceOperation toResourceOperation(UnmatchingRule rule) {
        switch (rule) {
            case ASSIGN: 
            case PROVISION: {
                return ResourceOperation.CREATE;
            }
        }
        return ResourceOperation.NONE;
    }

    private ResourceOperation toResourceOperation(MatchingRule rule) {
        switch (rule) {
            case UPDATE: {
                return ResourceOperation.UPDATE;
            }
            case DEPROVISION: 
            case UNASSIGN: {
                return ResourceOperation.DELETE;
            }
        }
        return ResourceOperation.NONE;
    }

    private ProvisioningReport.Status toProvisioningReportStatus(PropagationTaskExecStatus status) {
        switch (status) {
            case FAILURE: {
                return ProvisioningReport.Status.FAILURE;
            }
            case SUCCESS: {
                return ProvisioningReport.Status.SUCCESS;
            }
        }
        return ProvisioningReport.Status.IGNORE;
    }
}

