/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationActions;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SCIMv11PropagationActions
extends DefaultPropagationActions {
    private static final Logger LOG = LoggerFactory.getLogger(SCIMv11PropagationActions.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    protected String getSCIMIdSchema() {
        return "SCIMUserId";
    }

    @Override
    @Transactional
    public void after(PropagationTask task, TaskExec execution, ConnectorObject afterObj) {
        if (task.getOperation() == ResourceOperation.DELETE || task.getOperation() == ResourceOperation.NONE) {
            return;
        }
        if (AnyTypeKind.USER.equals((Object)task.getAnyTypeKind())) {
            User user = (User)this.userDAO.find(task.getEntityKey());
            if (user == null) {
                LOG.error("Could not find user {}, skipping", (Object)task.getEntityKey());
            } else {
                boolean modified = false;
                AnyUtils anyUtils = this.anyUtilsFactory.getInstance((Any)user);
                PlainSchema userId = (PlainSchema)this.plainSchemaDAO.find(this.getSCIMIdSchema());
                if (userId == null) {
                    LOG.error("Could not find schema {}, skipping", (Object)this.getSCIMIdSchema());
                } else {
                    UPlainAttr attr = (UPlainAttr)user.getPlainAttr(this.getSCIMIdSchema());
                    if (attr == null) {
                        attr = (UPlainAttr)this.entityFactory.newEntity(UPlainAttr.class);
                        attr.setSchema(userId);
                        attr.setOwner((Any)user);
                        user.add((GroupablePlainAttr)attr);
                        try {
                            attr.add(afterObj.getUid().getUidValue(), anyUtils);
                            modified = true;
                        }
                        catch (InvalidPlainAttrValueException e) {
                            LOG.error("Invalid value for attribute {}: {}", new Object[]{userId.getKey(), afterObj.getUid().getUidValue(), e});
                        }
                    } else {
                        LOG.debug("User {} has already {} assigned: {}", new Object[]{user, userId.getKey(), attr.getValuesAsStrings()});
                    }
                }
                if (modified) {
                    this.userDAO.save((Any)user);
                }
            }
        }
    }
}

