/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.java.propagation.AbstractPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationTaskCallable;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class PriorityPropagationTaskExecutor
extends AbstractPropagationTaskExecutor {
    @Resource(name="propagationTaskExecutorAsyncExecutor")
    protected ThreadPoolTaskExecutor executor;

    protected PropagationTaskCallable newPropagationTaskCallable(PropagationTaskTO taskTO, PropagationReporter reporter) {
        PropagationTaskCallable callable = (PropagationTaskCallable)ApplicationContextProvider.getBeanFactory().createBean(DefaultPropagationTaskCallable.class, 2, false);
        callable.setTaskTO(taskTO);
        callable.setReporter(reporter);
        return callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void doExecute(Collection<PropagationTaskTO> tasks, PropagationReporter reporter, boolean nullPriorityAsync) {
        block16: {
            HashMap<PropagationTaskTO, ExternalResource> taskToResource = new HashMap<PropagationTaskTO, ExternalResource>(tasks.size());
            ArrayList<PropagationTaskTO> prioritizedTasks = new ArrayList<PropagationTaskTO>();
            int connRequestTimeout = 60;
            for (PropagationTaskTO propagationTaskTO : tasks) {
                ExternalResource resource = this.resourceDAO.find(propagationTaskTO.getResource());
                taskToResource.put(propagationTaskTO, resource);
                if (resource.getPropagationPriority() == null) continue;
                prioritizedTasks.add(propagationTaskTO);
                if (resource.getConnector().getConnRequestTimeout() == null || connRequestTimeout >= resource.getConnector().getConnRequestTimeout()) continue;
                connRequestTimeout = resource.getConnector().getConnRequestTimeout();
                LOG.debug("Upgrade request connection timeout to {}", (Object)connRequestTimeout);
            }
            Collections.sort(prioritizedTasks, new PriorityComparator(taskToResource));
            LOG.debug("Propagation tasks sorted by priority, for serial execution: {}", prioritizedTasks);
            Collection concurrentTasks = CollectionUtils.subtract(tasks, prioritizedTasks);
            LOG.debug("Propagation tasks for concurrent execution: {}", (Object)concurrentTasks);
            for (PropagationTaskTO task : prioritizedTasks) {
                void var11_13;
                Object execution = null;
                try {
                    execution = (TaskExec)this.newPropagationTaskCallable(task, reporter).call();
                    PropagationTaskExecStatus propagationTaskExecStatus = PropagationTaskExecStatus.valueOf((String)execution.getStatus());
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                    PropagationTaskExecStatus propagationTaskExecStatus = PropagationTaskExecStatus.FAILURE;
                }
                if (var11_13 == PropagationTaskExecStatus.SUCCESS) continue;
                throw new PropagationException(task.getResource(), execution == null ? null : execution.getMessage());
            }
            final ExecutorCompletionService executorCompletionService = new ExecutorCompletionService((Executor)this.executor);
            HashMap nullPriority = new HashMap(concurrentTasks.size());
            for (PropagationTaskTO propagationTaskTO : concurrentTasks) {
                try {
                    nullPriority.put(propagationTaskTO, executorCompletionService.submit(this.newPropagationTaskCallable(propagationTaskTO, reporter)));
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                }
            }
            if (nullPriority.isEmpty()) break block16;
            if (nullPriorityAsync) {
                for (Map.Entry entry : nullPriority.entrySet()) {
                    reporter.onSuccessOrNonPriorityResourceFailures((PropagationTaskTO)entry.getKey(), PropagationTaskExecStatus.CREATED, null, null, null);
                }
            } else {
                final HashSet nullPriorityFutures = new HashSet(nullPriority.values());
                try {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            while (!nullPriorityFutures.isEmpty()) {
                                try {
                                    nullPriorityFutures.remove(executorCompletionService.take());
                                }
                                catch (Exception e) {
                                    AbstractPropagationTaskExecutor.LOG.error("Unexpected exception", (Throwable)e);
                                }
                            }
                        }
                    }).get(connRequestTimeout, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    LOG.error("Unexpected exception", (Throwable)exception);
                }
                finally {
                    for (Future future : nullPriorityFutures) {
                        future.cancel(true);
                    }
                    nullPriorityFutures.clear();
                    nullPriority.clear();
                }
            }
        }
    }

    protected static class PriorityComparator
    implements Comparator<PropagationTaskTO>,
    Serializable {
        private static final long serialVersionUID = -1969355670784448878L;
        private final Map<PropagationTaskTO, ExternalResource> taskToResource;

        public PriorityComparator(Map<PropagationTaskTO, ExternalResource> taskToResource) {
            this.taskToResource = taskToResource;
        }

        @Override
        public int compare(PropagationTaskTO task1, PropagationTaskTO task2) {
            int prop2;
            int prop1 = this.taskToResource.get(task1).getPropagationPriority();
            return prop1 > (prop2 = this.taskToResource.get(task2).getPropagationPriority().intValue()) ? 1 : (prop1 == prop2 ? 0 : -1);
        }
    }
}

