/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.HashSet;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.group.GPlainAttr;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationActions;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class AzurePropagationActions
extends DefaultPropagationActions {
    private static final Logger LOG = LoggerFactory.getLogger(AzurePropagationActions.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    protected String getEmailAttrName() {
        return "mailNickname";
    }

    protected String getAzureUserIdSchema() {
        return "AzureUserId";
    }

    protected String getAzureGroupIdSchema() {
        return "AzureGroupId";
    }

    @Override
    @Transactional
    public void before(PropagationTask task, ConnectorObject beforeObj) {
        super.before(task, beforeObj);
        if (task.getOperation() == ResourceOperation.DELETE || task.getOperation() == ResourceOperation.NONE) {
            return;
        }
        switch (task.getAnyTypeKind()) {
            case USER: {
                this.setName(task);
                break;
            }
            case GROUP: {
                this.setName(task);
                break;
            }
            default: {
                LOG.debug("Not about user, or group, not doing anything");
            }
        }
    }

    private void setName(PropagationTask task) {
        HashSet<Name> attrs = new HashSet<Name>(task.getAttributes());
        if (AttributeUtil.find((String)this.getEmailAttrName(), attrs) == null) {
            LOG.warn("Can't find {} attribute to set as __NAME__ attribute value, skipping...", (Object)this.getEmailAttrName());
            return;
        }
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        if (name != null) {
            attrs.remove(name);
        }
        attrs.add(new Name(AttributeUtil.find((String)this.getEmailAttrName(), attrs).getValue().get(0).toString()));
        task.setAttributes(attrs);
    }

    @Override
    @Transactional
    public void after(PropagationTask task, TaskExec execution, ConnectorObject afterObj) {
        if (task.getOperation() == ResourceOperation.DELETE || task.getOperation() == ResourceOperation.NONE) {
            return;
        }
        if (AnyTypeKind.USER.equals((Object)task.getAnyTypeKind())) {
            User user = (User)this.userDAO.find(task.getEntityKey());
            if (user == null) {
                LOG.error("Could not find user {}, skipping", (Object)task.getEntityKey());
            } else {
                boolean modified = false;
                AnyUtils anyUtils = this.anyUtilsFactory.getInstance((Any)user);
                PlainSchema azureId = (PlainSchema)this.plainSchemaDAO.find(this.getAzureUserIdSchema());
                if (azureId == null) {
                    LOG.error("Could not find schema {}, skipping", (Object)this.getAzureUserIdSchema());
                } else {
                    UPlainAttr attr = (UPlainAttr)user.getPlainAttr(this.getAzureUserIdSchema());
                    if (attr == null) {
                        attr = (UPlainAttr)this.entityFactory.newEntity(UPlainAttr.class);
                        attr.setSchema(azureId);
                        attr.setOwner((Any)user);
                        user.add((GroupablePlainAttr)attr);
                        try {
                            attr.add(afterObj.getUid().getUidValue(), anyUtils);
                            modified = true;
                        }
                        catch (InvalidPlainAttrValueException e) {
                            LOG.error("Invalid value for attribute {}: {}", new Object[]{azureId.getKey(), afterObj.getUid().getUidValue(), e});
                        }
                    } else {
                        LOG.debug("User {} has already {} assigned: {}", new Object[]{user, azureId.getKey(), attr.getValuesAsStrings()});
                    }
                }
                if (modified) {
                    this.userDAO.save((Any)user);
                }
            }
        } else if (AnyTypeKind.GROUP.equals((Object)task.getAnyTypeKind())) {
            Group group = (Group)this.groupDAO.find(task.getEntityKey());
            if (group == null) {
                LOG.error("Could not find group {}, skipping", (Object)task.getEntityKey());
            } else {
                boolean modified = false;
                AnyUtils anyUtils = this.anyUtilsFactory.getInstance((Any)group);
                PlainSchema azureId = (PlainSchema)this.plainSchemaDAO.find(this.getAzureGroupIdSchema());
                if (azureId == null) {
                    LOG.error("Could not find schema {}, skipping", (Object)this.getAzureGroupIdSchema());
                } else {
                    GPlainAttr attr = group.getPlainAttr(this.getAzureGroupIdSchema());
                    if (attr == null) {
                        attr = (GPlainAttr)this.entityFactory.newEntity(GPlainAttr.class);
                        attr.setSchema(azureId);
                        attr.setOwner((Any)group);
                        group.add(attr);
                        try {
                            attr.add(afterObj.getUid().getUidValue(), anyUtils);
                            modified = true;
                        }
                        catch (InvalidPlainAttrValueException e) {
                            LOG.error("Invalid value for attribute {}: {}", new Object[]{azureId.getKey(), afterObj.getUid().getUidValue(), e});
                        }
                    } else {
                        LOG.debug("Group {} has already {} assigned: {}", new Object[]{group, azureId.getKey(), attr.getValuesAsStrings()});
                    }
                }
                if (modified) {
                    this.groupDAO.save((Any)group);
                }
            }
        }
    }
}

