/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.report.GroupReportletConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ReportletConfClass;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.java.job.report.AbstractReportlet;
import org.apache.syncope.core.provisioning.java.job.report.ReportException;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@ReportletConfClass(value=GroupReportletConf.class)
public class GroupReportlet
extends AbstractReportlet {
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private GroupDataBinder groupDataBinder;
    private GroupReportletConf conf;

    private void doExtractResources(ContentHandler handler, AnyTO anyTO) throws SAXException {
        if (anyTO.getResources().isEmpty()) {
            LOG.debug("No resources found for {}[{}]", (Object)anyTO.getClass().getSimpleName(), (Object)anyTO.getKey());
        } else {
            AttributesImpl atts = new AttributesImpl();
            handler.startElement("", "", "resources", null);
            for (String resourceName : anyTO.getResources()) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", resourceName);
                handler.startElement("", "", "resource", atts);
                handler.endElement("", "", "resource");
            }
            handler.endElement("", "", "resources");
        }
    }

    private void doExtractAttributes(ContentHandler handler, AnyTO anyTO, Collection<String> attrs, Collection<String> derAttrs, Collection<String> virAttrs) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (!attrs.isEmpty()) {
            Map attrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getPlainAttrs());
            handler.startElement("", "", "attributes", null);
            for (String attrName : attrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "attribute", atts);
                if (attrMap.containsKey(attrName)) {
                    for (String value : ((AttrTO)attrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, anyTO.getClass().getSimpleName(), anyTO.getKey()});
                }
                handler.endElement("", "", "attribute");
            }
            handler.endElement("", "", "attributes");
        }
        if (!derAttrs.isEmpty()) {
            Map derAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getDerAttrs());
            handler.startElement("", "", "derivedAttributes", null);
            for (String attrName : derAttrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "derivedAttribute", atts);
                if (derAttrMap.containsKey(attrName)) {
                    for (String value : ((AttrTO)derAttrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, anyTO.getClass().getSimpleName(), anyTO.getKey()});
                }
                handler.endElement("", "", "derivedAttribute");
            }
            handler.endElement("", "", "derivedAttributes");
        }
        if (!virAttrs.isEmpty()) {
            Map virAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getVirAttrs());
            handler.startElement("", "", "virtualAttributes", null);
            for (String attrName : virAttrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "virtualAttribute", atts);
                if (virAttrMap.containsKey(attrName)) {
                    for (String value : ((AttrTO)virAttrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, anyTO.getClass().getSimpleName(), anyTO.getKey()});
                }
                handler.endElement("", "", "virtualAttribute");
            }
            handler.endElement("", "", "virtualAttributes");
        }
    }

    private void doExtract(ContentHandler handler, List<Group> groups) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        for (Group group : groups) {
            atts.clear();
            for (GroupReportletConf.Feature feature : this.conf.getFeatures()) {
                String type = null;
                String value = null;
                switch (feature) {
                    case key: {
                        type = "xsd:string";
                        value = group.getKey();
                        break;
                    }
                    case name: {
                        type = "xsd:string";
                        value = String.valueOf(group.getName());
                        break;
                    }
                    case groupOwner: {
                        type = "xsd:string";
                        value = group.getGroupOwner().getKey();
                        break;
                    }
                    case userOwner: {
                        type = "xsd:string";
                        value = group.getUserOwner().getKey();
                        break;
                    }
                }
                if (type == null || value == null) continue;
                atts.addAttribute("", "", feature.name(), type, value);
            }
            handler.startElement("", "", "group", atts);
            GroupTO groupTO = this.groupDataBinder.getGroupTO(group, true);
            this.doExtractAttributes(handler, (AnyTO)groupTO, this.conf.getPlainAttrs(), this.conf.getDerAttrs(), this.conf.getVirAttrs());
            if (this.conf.getFeatures().contains(GroupReportletConf.Feature.resources)) {
                this.doExtractResources(handler, (AnyTO)groupTO);
            }
            if (this.conf.getFeatures().contains(GroupReportletConf.Feature.users)) {
                handler.startElement("", "", "users", null);
                for (UMembership memb : this.groupDAO.findUMemberships(group)) {
                    atts.clear();
                    atts.addAttribute("", "", "key", "xsd:string", ((User)memb.getLeftEnd()).getKey());
                    atts.addAttribute("", "", "username", "xsd:string", String.valueOf(((User)memb.getLeftEnd()).getUsername()));
                    handler.startElement("", "", "user", atts);
                    handler.endElement("", "", "user");
                }
                handler.endElement("", "", "users");
            }
            handler.endElement("", "", "group");
        }
    }

    private void doExtractConf(ContentHandler handler) throws SAXException {
        if (this.conf == null) {
            LOG.debug("Report configuration is not present");
        }
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "", "configurations", null);
        handler.startElement("", "", "groupAttributes", atts);
        if (this.conf != null) {
            for (GroupReportletConf.Feature feature : this.conf.getFeatures()) {
                atts.clear();
                handler.startElement("", "", "feature", atts);
                handler.characters(feature.name().toCharArray(), 0, feature.name().length());
                handler.endElement("", "", "feature");
            }
            for (String attr : this.conf.getPlainAttrs()) {
                atts.clear();
                handler.startElement("", "", "attribute", atts);
                handler.characters(attr.toCharArray(), 0, attr.length());
                handler.endElement("", "", "attribute");
            }
            for (String derAttr : this.conf.getDerAttrs()) {
                atts.clear();
                handler.startElement("", "", "derAttribute", atts);
                handler.characters(derAttr.toCharArray(), 0, derAttr.length());
                handler.endElement("", "", "derAttribute");
            }
            for (String virAttr : this.conf.getVirAttrs()) {
                atts.clear();
                handler.startElement("", "", "virAttribute", atts);
                handler.characters(virAttr.toCharArray(), 0, virAttr.length());
                handler.endElement("", "", "virAttribute");
            }
        }
        handler.endElement("", "", "groupAttributes");
        handler.endElement("", "", "configurations");
    }

    private int count() {
        return StringUtils.isBlank((CharSequence)this.conf.getMatchingCond()) ? this.groupDAO.count() : this.searchDAO.count(SyncopeConstants.FULL_ADMIN_REALMS, SearchCondConverter.convert((String)this.conf.getMatchingCond(), (String[])new String[0]), AnyTypeKind.GROUP);
    }

    @Override
    protected void doExtract(ReportletConf conf, ContentHandler handler, AtomicReference<String> status) throws SAXException {
        if (!(conf instanceof GroupReportletConf)) {
            throw new ReportException(new IllegalArgumentException("Invalid configuration provided"));
        }
        this.conf = (GroupReportletConf)GroupReportletConf.class.cast(conf);
        this.doExtractConf(handler);
        int total = this.count();
        int pages = total / 500 + 1;
        status.set("Processing " + total + " groups in " + pages + " pages");
        for (int page = 1; page <= pages; ++page) {
            status.set("Processing " + total + " groups: page " + page + " of " + pages);
            List groups = StringUtils.isBlank((CharSequence)this.conf.getMatchingCond()) ? this.groupDAO.findAll(page, 500) : this.searchDAO.search(SyncopeConstants.FULL_ADMIN_REALMS, SearchCondConverter.convert((String)this.conf.getMatchingCond(), (String[])new String[0]), page, 500, Collections.emptyList(), AnyTypeKind.USER);
            this.doExtract(handler, groups);
            status.set("Processed " + total + " groups: page " + page + " of " + pages);
        }
    }
}

