/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.notification;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.LogOutputStream;
import org.apache.syncope.common.lib.PropertyUtils;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DefaultNotificationJobDelegate
implements InitializingBean,
NotificationJobDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationJobDelegate.class);
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private NotificationManager notificationManager;
    private final AtomicReference<String> status = new AtomicReference();
    private boolean interrupt;
    private boolean interrupted;

    public void afterPropertiesSet() throws Exception {
        if (this.mailSender instanceof JavaMailSenderImpl) {
            JavaMailSenderImpl javaMailSender = (JavaMailSenderImpl)this.mailSender;
            Properties javaMailProperties = javaMailSender.getJavaMailProperties();
            Properties props = (Properties)PropertyUtils.read(Encryptor.class, (String)"mail.properties", (String)"conf.directory").getLeft();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                if (!prop.startsWith("mail.smtp.")) continue;
                javaMailProperties.setProperty(prop, props.getProperty(prop));
            }
            if (StringUtils.isNotBlank((CharSequence)javaMailSender.getUsername())) {
                javaMailProperties.setProperty("mail.smtp.auth", "true");
            }
            javaMailSender.setJavaMailProperties(javaMailProperties);
            String mailDebug = props.getProperty("mail.debug", "false");
            if (BooleanUtils.toBoolean((String)mailDebug)) {
                Session session = javaMailSender.getSession();
                session.setDebug(true);
                session.setDebugOut(new PrintStream((OutputStream)new LogOutputStream(LOG)));
            }
        }
    }

    public String currentStatus() {
        return this.status.get();
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Transactional
    public TaskExec executeSingle(NotificationTask task) {
        TaskExec execution = (TaskExec)this.entityFactory.newEntity(TaskExec.class);
        execution.setTask((Task)task);
        execution.setStart(new Date());
        boolean retryPossible = true;
        if (StringUtils.isBlank((CharSequence)task.getSubject()) || task.getRecipients().isEmpty() || StringUtils.isBlank((CharSequence)task.getHtmlBody()) || StringUtils.isBlank((CharSequence)task.getTextBody())) {
            String message = "Could not fetch all required information for sending e-mails:\n" + task.getRecipients() + "\n" + task.getSender() + "\n" + task.getSubject() + "\n" + task.getHtmlBody() + "\n" + task.getTextBody();
            LOG.error(message);
            execution.setStatus(NotificationJob.Status.NOT_SENT.name());
            retryPossible = false;
            if (task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                execution.setMessage(message);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("About to send e-mails:\n" + task.getRecipients() + "\n" + task.getSender() + "\n" + task.getSubject() + "\n" + task.getHtmlBody() + "\n" + task.getTextBody() + "\n");
            }
            this.status.set("Sending notifications to " + task.getRecipients());
            for (String to : task.getRecipients()) {
                try {
                    MimeMessage message = this.mailSender.createMimeMessage();
                    MimeMessageHelper helper = new MimeMessageHelper(message, true);
                    helper.setTo(to);
                    helper.setFrom(task.getSender());
                    helper.setSubject(task.getSubject());
                    helper.setText(task.getTextBody(), task.getHtmlBody());
                    this.mailSender.send(message);
                    execution.setStatus(NotificationJob.Status.SENT.name());
                    StringBuilder report = new StringBuilder();
                    switch (task.getTraceLevel()) {
                        case ALL: {
                            report.append("FROM: ").append(task.getSender()).append('\n').append("TO: ").append(to).append('\n').append("SUBJECT: ").append(task.getSubject()).append('\n').append('\n').append(task.getTextBody()).append('\n').append('\n').append(task.getHtmlBody()).append('\n');
                            break;
                        }
                        case SUMMARY: {
                            report.append("E-mail sent to ").append(to).append('\n');
                            break;
                        }
                    }
                    if (report.length() > 0) {
                        execution.setMessage(report.toString());
                    }
                    this.notificationManager.createTasks(AuditElements.EventCategoryType.TASK, "notification", null, "send", AuditElements.Result.SUCCESS, null, null, new Object[]{task, "Successfully sent notification to " + to});
                }
                catch (Exception e) {
                    LOG.error("Could not send e-mail", (Throwable)e);
                    execution.setStatus(NotificationJob.Status.NOT_SENT.name());
                    if (task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                        execution.setMessage(ExceptionUtils2.getFullStackTrace((Throwable)e));
                    }
                    this.notificationManager.createTasks(AuditElements.EventCategoryType.TASK, "notification", null, "send", AuditElements.Result.FAILURE, null, null, new Object[]{task, "Could not send notification to " + to, e});
                }
                execution.setEnd(new Date());
            }
        }
        if (this.hasToBeRegistered(execution)) {
            execution = this.notificationManager.storeExec(execution);
            if (retryPossible && NotificationJob.Status.valueOf(execution.getStatus()) == NotificationJob.Status.NOT_SENT) {
                this.handleRetries(execution);
            }
        } else {
            this.notificationManager.setTaskExecuted(execution.getTask().getKey(), true);
        }
        return execution;
    }

    @Transactional
    public void execute() throws JobExecutionException {
        List tasks = this.taskDAO.findToExec(TaskType.NOTIFICATION);
        this.status.set("Sending out " + tasks.size() + " notifications");
        for (int i = 0; i < tasks.size() && !this.interrupt; ++i) {
            LOG.debug("Found notification task {} to be executed: starting...", tasks.get(i));
            this.executeSingle((NotificationTask)tasks.get(i));
            LOG.debug("Notification task {} executed", tasks.get(i));
        }
        if (this.interrupt) {
            LOG.debug("Notification job interrupted");
            this.interrupted = true;
        }
    }

    private boolean hasToBeRegistered(TaskExec execution) {
        NotificationTask task = (NotificationTask)execution.getTask();
        return NotificationJob.Status.valueOf(execution.getStatus()) == NotificationJob.Status.NOT_SENT && task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getTraceLevel() == TraceLevel.ALL;
    }

    private void handleRetries(TaskExec execution) {
        if (this.notificationManager.getMaxRetries() <= 0L) {
            return;
        }
        long failedExecutionsCount = this.notificationManager.countExecutionsWithStatus(execution.getTask().getKey(), NotificationJob.Status.NOT_SENT.name());
        if (failedExecutionsCount <= this.notificationManager.getMaxRetries()) {
            LOG.debug("Execution of notification task {} will be retried [{}/{}]", new Object[]{execution.getTask(), failedExecutionsCount, this.notificationManager.getMaxRetries()});
            this.notificationManager.setTaskExecuted(execution.getTask().getKey(), false);
            this.auditManager.audit(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.TASK, "notification", null, "retry", AuditElements.Result.SUCCESS, null, null, new Object[]{execution, "Notification task " + execution.getTask().getKey() + " will be retried"});
        } else {
            LOG.error("Maximum number of retries reached for task {} - giving up", (Object)execution.getTask());
            this.auditManager.audit(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.TASK, "notification", null, "retry", AuditElements.Result.FAILURE, null, null, new Object[]{execution, "Giving up retries on notification task " + execution.getTask().getKey()});
        }
    }
}

