/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SetUMembershipsJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(SetUMembershipsJob.class);
    public static final String MEMBERSHIPS_BEFORE_KEY = "membershipsBefore";
    public static final String MEMBERSHIPS_AFTER_KEY = "membershipsAfter";
    @Autowired
    private UserProvisioningManager userProvisioningManager;

    public void execute(final JobExecutionContext context) throws JobExecutionException {
        try {
            AuthContextUtils.execWithAuthContext((String)context.getMergedJobDataMap().getString("domain"), (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                public Void exec() {
                    UserPatch userPatch;
                    Map membershipsBefore = (Map)context.getMergedJobDataMap().get((Object)SetUMembershipsJob.MEMBERSHIPS_BEFORE_KEY);
                    LOG.debug("Memberships before pull (User -> Groups) {}", (Object)membershipsBefore);
                    Map membershipsAfter = (Map)context.getMergedJobDataMap().get((Object)SetUMembershipsJob.MEMBERSHIPS_AFTER_KEY);
                    LOG.debug("Memberships after pull (User -> Groups) {}", (Object)membershipsAfter);
                    ArrayList<UserPatch> patches = new ArrayList<UserPatch>();
                    for (final Map.Entry membership : membershipsAfter.entrySet()) {
                        userPatch = new UserPatch();
                        userPatch.setKey((String)membership.getKey());
                        patches.add(userPatch);
                        for (String group : (Set)membership.getValue()) {
                            Set before = (Set)membershipsBefore.get(membership.getKey());
                            if (before != null && before.contains(group)) continue;
                            userPatch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(group).build());
                        }
                    }
                    for (final Map.Entry membership : membershipsBefore.entrySet()) {
                        userPatch = (UserPatch)IterableUtils.find(patches, (Predicate)new Predicate<UserPatch>(){

                            public boolean evaluate(UserPatch patch) {
                                return ((String)membership.getKey()).equals(patch.getKey());
                            }
                        });
                        if (userPatch == null) {
                            userPatch = new UserPatch();
                            userPatch.setKey((String)membership.getKey());
                            patches.add(userPatch);
                        }
                        for (String group : (Set)membership.getValue()) {
                            Set after = (Set)membershipsAfter.get(membership.getKey());
                            if (after != null && after.contains(group)) continue;
                            userPatch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).group(group).build());
                        }
                    }
                    for (UserPatch patch : patches) {
                        if (patch.isEmpty()) continue;
                        LOG.debug("About to update User {}", (Object)patch);
                        SetUMembershipsJob.this.userProvisioningManager.update((AnyPatch)patch, true);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            LOG.error("While setting memberships", (Throwable)e);
            throw new JobExecutionException("While executing memberships", (Throwable)e);
        }
    }
}

