/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.policy.AbstractAccountRuleConf;
import org.apache.syncope.common.lib.policy.AbstractPasswordRuleConf;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.PullPolicyTO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyDataBinderImpl
implements PolicyDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyDataBinder.class);
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private EntityFactory entityFactory;

    private <T extends Policy> T getPolicy(T policy, PolicyTO policyTO) {
        Object result = policy;
        if (policyTO instanceof PasswordPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PasswordPolicy.class);
            }
            PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(result);
            PasswordPolicyTO passwordPolicyTO = (PasswordPolicyTO)PasswordPolicyTO.class.cast(policyTO);
            passwordPolicy.setAllowNullPassword(passwordPolicyTO.isAllowNullPassword());
            passwordPolicy.setHistoryLength(passwordPolicyTO.getHistoryLength());
            passwordPolicy.removeAllRuleConfs();
            for (PasswordRuleConf conf : passwordPolicyTO.getRuleConfs()) {
                passwordPolicy.add(conf);
            }
        } else if (policyTO instanceof AccountPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(AccountPolicy.class);
            }
            AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(result);
            AccountPolicyTO accountPolicyTO = (AccountPolicyTO)AccountPolicyTO.class.cast(policyTO);
            accountPolicy.setMaxAuthenticationAttempts(accountPolicyTO.getMaxAuthenticationAttempts());
            accountPolicy.setPropagateSuspension(accountPolicyTO.isPropagateSuspension());
            accountPolicy.removeAllRuleConfs();
            for (AccountRuleConf conf : accountPolicyTO.getRuleConfs()) {
                accountPolicy.add(conf);
            }
            accountPolicy.getResources().clear();
            for (String resourceName : accountPolicyTO.getPassthroughResources()) {
                ExternalResource resource = this.resourceDAO.find(resourceName);
                if (resource == null) {
                    LOG.debug("Ignoring invalid resource {} ", (Object)resourceName);
                    continue;
                }
                accountPolicy.add(resource);
            }
        } else if (policyTO instanceof PullPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PullPolicy.class);
            }
            ((PullPolicy)result).setSpecification(((PullPolicyTO)policyTO).getSpecification());
        }
        if (result != null) {
            result.setDescription(policyTO.getDescription());
        }
        return result;
    }

    public <T extends Policy> T create(PolicyTO policyTO) {
        return this.getPolicy(null, policyTO);
    }

    public <T extends Policy> T update(T policy, PolicyTO policyTO) {
        return this.getPolicy(policy, policyTO);
    }

    public <T extends PolicyTO> T getPolicyTO(Policy policy) {
        PullPolicyTO policyTO = null;
        if (policy instanceof PasswordPolicy) {
            PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(policy);
            PasswordPolicyTO passwordPolicyTO = new PasswordPolicyTO();
            policyTO = passwordPolicyTO;
            passwordPolicyTO.setAllowNullPassword(passwordPolicy.isAllowNullPassword());
            passwordPolicyTO.setHistoryLength(passwordPolicy.getHistoryLength());
            for (PasswordRuleConf ruleConf : passwordPolicy.getRuleConfs()) {
                passwordPolicyTO.getRuleConfs().add((AbstractPasswordRuleConf)ruleConf);
            }
        } else if (policy instanceof AccountPolicy) {
            AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(policy);
            AccountPolicyTO accountPolicyTO = new AccountPolicyTO();
            policyTO = accountPolicyTO;
            accountPolicyTO.setMaxAuthenticationAttempts(accountPolicy.getMaxAuthenticationAttempts());
            accountPolicyTO.setPropagateSuspension(accountPolicy.isPropagateSuspension());
            for (PasswordRuleConf ruleConf : accountPolicy.getRuleConfs()) {
                accountPolicyTO.getRuleConfs().add((AbstractAccountRuleConf)ruleConf);
            }
            accountPolicyTO.getPassthroughResources().addAll(accountPolicy.getResourceNames());
        } else if (policy instanceof PullPolicy) {
            policyTO = new PullPolicyTO();
            policyTO.setSpecification(((PullPolicy)policy).getSpecification());
        }
        if (policyTO != null) {
            policyTO.setKey(policy.getKey());
            policyTO.setDescription(policy.getDescription());
            for (ExternalResource resource : this.resourceDAO.findByPolicy(policy)) {
                policyTO.getUsedByResources().add(resource.getKey());
            }
            for (Realm realm : this.realmDAO.findByPolicy(policy)) {
                policyTO.getUsedByRealms().add(realm.getFullPath());
            }
        }
        return (T)policyTO;
    }
}

