/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnitItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.utils.policy.InvalidPasswordRuleConf;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.identityconnectors.common.Base64;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MappingManagerImpl
implements MappingManager {
    private static final Logger LOG = LoggerFactory.getLogger(MappingManager.class);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private RelationshipTypeDAO relationshipTypeDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private DerAttrHandler derAttrHandler;
    @Autowired
    private VirAttrHandler virAttrHandler;
    @Autowired
    private VirAttrCache virAttrCache;
    @Autowired
    private PasswordGenerator passwordGenerator;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    @Transactional(readOnly=true)
    public Pair<String, Set<Attribute>> prepareAttrs(Any<?> any, String password, boolean changePwd, Boolean enable, Provision provision) {
        Attribute attribute;
        LOG.debug("Preparing resource attributes for {} with provision {} for attributes {}", new Object[]{any, provision, any.getPlainAttrs()});
        HashSet<Object> attributes = new HashSet<Object>();
        String connObjectKey = null;
        for (Item item : MappingUtils.getPropagationItems(provision.getMapping().getItems())) {
            LOG.debug("Processing expression '{}'", (Object)item.getIntAttrName());
            try {
                Pair<String, Attribute> preparedAttr = this.prepareAttr(provision, item, any, password);
                if (preparedAttr == null) continue;
                if (preparedAttr.getLeft() != null) {
                    connObjectKey = (String)preparedAttr.getLeft();
                }
                if (preparedAttr.getRight() == null) continue;
                Attribute alreadyAdded = AttributeUtil.find((String)((Attribute)preparedAttr.getRight()).getName(), attributes);
                if (alreadyAdded == null) {
                    attributes.add(preparedAttr.getRight());
                    continue;
                }
                attributes.remove(alreadyAdded);
                HashSet values = new HashSet();
                if (CollectionUtils.isNotEmpty((Collection)alreadyAdded.getValue())) {
                    values.addAll(alreadyAdded.getValue());
                }
                if (((Attribute)preparedAttr.getRight()).getValue() != null) {
                    values.addAll(((Attribute)preparedAttr.getRight()).getValue());
                }
                attributes.add(AttributeBuilder.build((String)((Attribute)preparedAttr.getRight()).getName(), values));
            }
            catch (Exception e) {
                LOG.error("Expression '{}' processing failed", (Object)item.getIntAttrName(), (Object)e);
            }
        }
        MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
        if (connObjectKeyItem != null) {
            Attribute attribute2 = AttributeUtil.find((String)connObjectKeyItem.getExtAttrName(), attributes);
            if (attribute2 != null) {
                attributes.remove(attribute2);
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKey}));
            }
            Name name = MappingUtils.evaluateNAME(any, provision, connObjectKey);
            attributes.add(name);
            if (connObjectKey != null && !connObjectKey.equals(name.getNameValue()) && attribute2 == null) {
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKey}));
            }
        }
        if (enable != null) {
            attributes.add(AttributeBuilder.buildEnabled((boolean)enable));
        }
        if (!changePwd && (attribute = AttributeUtil.find((String)OperationalAttributes.PASSWORD_NAME, attributes)) != null) {
            attributes.remove(attribute);
        }
        return Pair.of(connObjectKey, attributes);
    }

    private String getIntValue(Realm realm, Item orgUnitItem) {
        String value = null;
        switch (orgUnitItem.getIntAttrName()) {
            case "key": {
                value = realm.getKey();
                break;
            }
            case "name": {
                value = realm.getName();
                break;
            }
            case "fullpath": {
                value = realm.getFullPath();
                break;
            }
        }
        return value;
    }

    public Pair<String, Set<Attribute>> prepareAttrs(Realm realm, OrgUnit orgUnit) {
        LOG.debug("Preparing resource attributes for {} with orgUnit {}", (Object)realm, (Object)orgUnit);
        HashSet<Object> attributes = new HashSet<Object>();
        String connObjectKey = null;
        for (Item item : MappingUtils.getPropagationItems(orgUnit.getItems())) {
            Attribute alreadyAdded;
            LOG.debug("Processing expression '{}'", (Object)item.getIntAttrName());
            String value = this.getIntValue(realm, item);
            if (item.isConnObjectKey()) {
                connObjectKey = value;
            }
            if ((alreadyAdded = AttributeUtil.find((String)item.getExtAttrName(), attributes)) == null) {
                if (value == null) {
                    attributes.add(AttributeBuilder.build((String)item.getExtAttrName()));
                    continue;
                }
                attributes.add(AttributeBuilder.build((String)item.getExtAttrName(), (Object[])new Object[]{value}));
                continue;
            }
            if (value == null) continue;
            attributes.remove(alreadyAdded);
            HashSet<String> values = new HashSet<String>();
            if (CollectionUtils.isNotEmpty((Collection)alreadyAdded.getValue())) {
                values.addAll(alreadyAdded.getValue());
            }
            values.add(value);
            attributes.add(AttributeBuilder.build((String)item.getExtAttrName(), values));
        }
        OrgUnitItem connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem != null) {
            Attribute attribute = AttributeUtil.find((String)connObjectKeyItem.getExtAttrName(), attributes);
            if (attribute != null) {
                attributes.remove(attribute);
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKey}));
            }
            attributes.add(MappingUtils.evaluateNAME(realm, orgUnit, connObjectKey));
        }
        return Pair.of(connObjectKey, attributes);
    }

    private Pair<String, Attribute> prepareAttr(Provision provision, Item mapItem, Any<?> any, String password) {
        Object result;
        IntAttrName intAttrName;
        try {
            intAttrName = this.intAttrNameParser.parse(mapItem.getIntAttrName(), provision.getAnyType().getKind());
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)mapItem.getIntAttrName(), (Object)e);
            return null;
        }
        boolean readOnlyVirSchema = false;
        Schema schema = null;
        AttrSchemaType schemaType = AttrSchemaType.String;
        if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    schema = this.plainSchemaDAO.find(intAttrName.getSchemaName());
                    if (schema == null) break;
                    schemaType = schema.getType();
                    break;
                }
                case VIRTUAL: {
                    schema = this.virSchemaDAO.find(intAttrName.getSchemaName());
                    readOnlyVirSchema = schema != null && schema.isReadonly();
                    break;
                }
            }
        }
        List<PlainAttrValue> values = this.getIntValues(provision, mapItem, intAttrName, any);
        LOG.debug("Define mapping for: \n* ExtAttrName " + mapItem.getExtAttrName() + "\n* is connObjectKey " + mapItem.isConnObjectKey() + "\n* is password " + mapItem.isPassword() + "\n* mandatory condition " + mapItem.getMandatoryCondition() + "\n* Schema " + intAttrName.getSchemaName() + "\n* ClassType " + schemaType.getType().getName() + "\n* Values " + values);
        if (readOnlyVirSchema) {
            result = null;
        } else {
            ArrayList<Object> objValues = new ArrayList<Object>();
            for (PlainAttrValue value : values) {
                if (FrameworkUtil.isSupportedAttributeType((Class)schemaType.getType())) {
                    objValues.add(value.getValue());
                    continue;
                }
                if (schema instanceof PlainSchema) {
                    objValues.add(value.getValueAsString((PlainSchema)schema));
                    continue;
                }
                objValues.add(value.getValueAsString(schemaType));
            }
            if (mapItem.isConnObjectKey()) {
                result = Pair.of(objValues.isEmpty() ? null : objValues.iterator().next().toString(), null);
            } else if (mapItem.isPassword() && any instanceof User) {
                String passwordAttrValue = password;
                if (StringUtils.isBlank((CharSequence)passwordAttrValue)) {
                    User user = (User)any;
                    if (user.canDecodePassword()) {
                        try {
                            passwordAttrValue = ENCRYPTOR.decode(user.getPassword(), user.getCipherAlgorithm());
                        }
                        catch (Exception e) {
                            LOG.error("Could not decode password for {}", (Object)user, (Object)e);
                        }
                    } else if (provision.getResource().isRandomPwdIfNotProvided()) {
                        try {
                            passwordAttrValue = this.passwordGenerator.generate(provision.getResource());
                        }
                        catch (InvalidPasswordRuleConf e) {
                            LOG.error("Could not generate policy-compliant random password for {}", (Object)user, (Object)e);
                        }
                    }
                }
                result = passwordAttrValue == null ? null : Pair.of(null, (Object)AttributeBuilder.buildPassword((char[])passwordAttrValue.toCharArray()));
            } else {
                result = Pair.of(null, (Object)(objValues.isEmpty() ? AttributeBuilder.build((String)mapItem.getExtAttrName()) : AttributeBuilder.build((String)mapItem.getExtAttrName(), objValues)));
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<PlainAttrValue> getIntValues(Provision provision, Item mapItem, IntAttrName intAttrName, Any<?> any) {
        LOG.debug("Get internal values for {} as '{}' on {}", new Object[]{any, mapItem.getIntAttrName(), provision.getResource()});
        ArrayList<Object> references = new ArrayList<Object>();
        Membership membership = null;
        if (intAttrName.getEnclosingGroup() == null && intAttrName.getRelatedAnyObject() == null && intAttrName.getRelationshipAnyType() == null && intAttrName.getRelationshipType() == null && intAttrName.getRelatedUser() == null) {
            references.add(any);
        }
        if (any instanceof GroupableRelatable) {
            Group group;
            GroupableRelatable groupableRelatable = (GroupableRelatable)any;
            if (intAttrName.getEnclosingGroup() != null) {
                group = this.groupDAO.findByName(intAttrName.getEnclosingGroup());
                if (group == null || groupableRelatable.getMembership(group.getKey()) == null) {
                    LOG.warn("No membership for {} in {}, ignoring", (Object)intAttrName.getEnclosingGroup(), (Object)groupableRelatable);
                } else {
                    references.add(group);
                }
            } else if (intAttrName.getRelatedUser() != null) {
                User user = this.userDAO.findByUsername(intAttrName.getRelatedUser());
                if (user == null || user.getRelationships(groupableRelatable.getKey()).isEmpty()) {
                    LOG.warn("No relationship for {} in {}, ignoring", (Object)intAttrName.getRelatedUser(), (Object)groupableRelatable);
                } else if (groupableRelatable.getType().getKind() == AnyTypeKind.USER) {
                    LOG.warn("Users cannot have relationship with other users, ignoring");
                } else {
                    references.add(user);
                }
            } else if (intAttrName.getRelatedAnyObject() != null) {
                AnyObject anyObject = this.anyObjectDAO.findByName(intAttrName.getRelatedAnyObject());
                if (anyObject == null || groupableRelatable.getRelationships(anyObject.getKey()).isEmpty()) {
                    LOG.warn("No relationship for {} in {}, ignoring", (Object)intAttrName.getRelatedAnyObject(), (Object)groupableRelatable);
                } else {
                    references.add(anyObject);
                }
            } else if (intAttrName.getRelationshipAnyType() != null && intAttrName.getRelationshipType() != null) {
                RelationshipType relationshipType = this.relationshipTypeDAO.find(intAttrName.getRelationshipType());
                final AnyType anyType = this.anyTypeDAO.find(intAttrName.getRelationshipAnyType());
                if (relationshipType == null || groupableRelatable.getRelationships(relationshipType).isEmpty()) {
                    LOG.warn("No relationship for type {} in {}, ignoring", (Object)intAttrName.getRelationshipType(), (Object)groupableRelatable);
                } else if (anyType == null) {
                    LOG.warn("No anyType {}, ignoring", (Object)intAttrName.getRelationshipAnyType());
                } else {
                    List list = ListUtils.select((Collection)groupableRelatable.getRelationships(relationshipType), (Predicate)new Predicate<Relationship<?, ?>>(){

                        public boolean evaluate(Relationship<?, ?> relationship) {
                            return anyType.equals(relationship.getRightEnd().getType());
                        }
                    });
                    for (Relationship result : list) {
                        references.add(result.getRightEnd());
                    }
                }
            } else if (intAttrName.getMembershipOfGroup() != null) {
                group = this.groupDAO.findByName(intAttrName.getMembershipOfGroup());
                membership = groupableRelatable.getMembership(group.getKey());
            }
        }
        if (references.isEmpty()) {
            LOG.warn("Could not determine the reference instance for {}", (Object)mapItem.getIntAttrName());
            return Collections.emptyList();
        }
        ArrayList<PlainAttrValue> values = new ArrayList<PlainAttrValue>();
        boolean transform = true;
        block25: for (Any any2 : references) {
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance(any2);
            if (intAttrName.getField() != null) {
                PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                switch (intAttrName.getField()) {
                    case "key": {
                        attrValue.setStringValue(any2.getKey());
                        values.add(attrValue);
                        break;
                    }
                    case "realm": {
                        attrValue.setStringValue(any2.getRealm().getFullPath());
                        values.add(attrValue);
                        break;
                    }
                    case "password": {
                        break;
                    }
                    case "userOwner": 
                    case "groupOwner": {
                        Mapping gMapping;
                        Mapping uMapping = provision.getAnyType().equals(this.anyTypeDAO.findUser()) ? provision.getMapping() : null;
                        Mapping mapping = gMapping = provision.getAnyType().equals(this.anyTypeDAO.findGroup()) ? provision.getMapping() : null;
                        if (!(any2 instanceof Group)) continue block25;
                        Group group = (Group)any2;
                        String groupOwnerValue = null;
                        if (group.getUserOwner() != null && uMapping != null) {
                            groupOwnerValue = this.getGroupOwnerValue(provision, (Any<?>)group.getUserOwner());
                        }
                        if (group.getGroupOwner() != null && gMapping != null) {
                            groupOwnerValue = this.getGroupOwnerValue(provision, (Any<?>)group.getGroupOwner());
                        }
                        if (!StringUtils.isNotBlank(groupOwnerValue)) continue block25;
                        attrValue.setStringValue(groupOwnerValue);
                        values.add(attrValue);
                        break;
                    }
                    case "suspended": {
                        if (!(any2 instanceof User)) continue block25;
                        attrValue.setBooleanValue(((User)any2).isSuspended());
                        values.add(attrValue);
                        break;
                    }
                    case "mustChangePassword": {
                        if (!(any2 instanceof User)) continue block25;
                        attrValue.setBooleanValue(Boolean.valueOf(((User)any2).isMustChangePassword()));
                        values.add(attrValue);
                        break;
                    }
                    default: {
                        try {
                            Object fieldValue = FieldUtils.readField((Object)any2, (String)intAttrName.getField(), (boolean)true);
                            if (fieldValue instanceof Date) {
                                attrValue.setStringValue(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format((Date)fieldValue));
                            } else if (Boolean.TYPE.isInstance(fieldValue)) {
                                attrValue.setBooleanValue((Boolean)fieldValue);
                            } else if (Double.TYPE.isInstance(fieldValue) || Float.TYPE.isInstance(fieldValue)) {
                                attrValue.setDoubleValue((Double)fieldValue);
                            } else if (Long.TYPE.isInstance(fieldValue) || Integer.TYPE.isInstance(fieldValue)) {
                                attrValue.setLongValue((Long)fieldValue);
                            } else {
                                attrValue.setStringValue(fieldValue.toString());
                            }
                            values.add(attrValue);
                            break;
                        }
                        catch (Exception e) {
                            LOG.error("Could not read value of '{}' from {}", new Object[]{intAttrName.getField(), any2, e});
                        }
                    }
                }
                continue;
            }
            if (intAttrName.getSchemaType() == null) continue;
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    Object attr = membership == null ? any2.getPlainAttr(intAttrName.getSchemaName()) : ((GroupableRelatable)any2).getPlainAttr(intAttrName.getSchemaName(), membership);
                    if (attr == null) break;
                    if (attr.getUniqueValue() != null) {
                        values.add(anyUtils.clonePlainAttrValue((PlainAttrValue)attr.getUniqueValue()));
                        break;
                    }
                    if (attr.getValues() == null) break;
                    for (PlainAttrValue value : attr.getValues()) {
                        values.add(anyUtils.clonePlainAttrValue(value));
                    }
                    continue block25;
                }
                case DERIVED: {
                    DerSchema derSchema = (DerSchema)this.derSchemaDAO.find(intAttrName.getSchemaName());
                    if (derSchema == null) break;
                    String value = membership == null ? this.derAttrHandler.getValue(any2, derSchema) : this.derAttrHandler.getValue(any2, membership, derSchema);
                    if (value == null) continue block25;
                    PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                    attrValue.setStringValue(value);
                    values.add(attrValue);
                    break;
                }
                case VIRTUAL: {
                    transform = false;
                    VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(intAttrName.getSchemaName());
                    if (virSchema == null) break;
                    LOG.debug("Expire entry cache {}-{}", (Object)any2, (Object)intAttrName.getSchemaName());
                    this.virAttrCache.expire(any2.getType().getKey(), any2.getKey(), intAttrName.getSchemaName());
                    List virValues = membership == null ? this.virAttrHandler.getValues(any2, virSchema) : this.virAttrHandler.getValues(any2, membership, virSchema);
                    for (String value : virValues) {
                        PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                        attrValue.setStringValue(value);
                        values.add(attrValue);
                    }
                    continue block25;
                }
            }
        }
        LOG.debug("Internal values: {}", values);
        List<Object> transformed = values;
        if (transform) {
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(mapItem)) {
                transformed = transformer.beforePropagation(mapItem, any, transformed);
            }
            LOG.debug("Transformed values: {}", values);
        } else {
            LOG.debug("No transformation occurred");
        }
        return transformed;
    }

    private String getGroupOwnerValue(Provision provision, Any<?> any) {
        MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
        Pair<String, Attribute> preparedAttr = null;
        if (connObjectKeyItem != null) {
            preparedAttr = this.prepareAttr(provision, (Item)connObjectKeyItem, any, null);
        }
        return preparedAttr == null ? null : MappingUtils.evaluateNAME(any, provision, (String)preparedAttr.getKey()).getNameValue();
    }

    @Transactional(readOnly=true)
    public String getConnObjectKeyValue(Any<?> any, Provision provision) {
        List<Object> values;
        MappingItem mapItem = provision.getMapping().getConnObjectKeyItem();
        try {
            values = this.getIntValues(provision, (Item)mapItem, this.intAttrNameParser.parse(mapItem.getIntAttrName(), provision.getAnyType().getKind()), any);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)mapItem.getIntAttrName(), (Object)e);
            values = Collections.emptyList();
        }
        return values.isEmpty() ? null : ((PlainAttrValue)values.get(0)).getValueAsString();
    }

    @Transactional(readOnly=true)
    public String getConnObjectKeyValue(Realm realm, OrgUnit orgUnit) {
        OrgUnitItem orgUnitItem = orgUnit.getConnObjectKeyItem();
        return orgUnitItem == null ? null : this.getIntValue(realm, (Item)orgUnitItem);
    }

    @Transactional(readOnly=true)
    public void setIntValues(Item mapItem, Attribute attr, AnyTO anyTO) {
        IntAttrName intAttrName;
        List values = null;
        if (attr != null) {
            values = attr.getValue();
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(mapItem)) {
                values = transformer.beforePull(mapItem, (EntityTO)anyTO, values);
            }
        }
        values = ListUtils.emptyIfNull(values);
        try {
            intAttrName = this.intAttrNameParser.parse(mapItem.getIntAttrName(), AnyTypeKind.fromTOClass(anyTO.getClass()));
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)mapItem.getIntAttrName(), (Object)e);
            return;
        }
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "password": {
                    if (!(anyTO instanceof UserTO) || values.isEmpty()) break;
                    ((UserTO)anyTO).setPassword(ConnObjectUtils.getPassword(values.get(0)));
                    break;
                }
                case "username": {
                    if (!(anyTO instanceof UserTO)) break;
                    ((UserTO)anyTO).setUsername(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
                    break;
                }
                case "name": {
                    if (anyTO instanceof GroupTO) {
                        ((GroupTO)anyTO).setName(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
                        break;
                    }
                    if (!(anyTO instanceof AnyObjectTO)) break;
                    ((AnyObjectTO)anyTO).setName(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
                    break;
                }
                case "mustChangePassword": {
                    if (!(anyTO instanceof UserTO) || values.isEmpty() || values.get(0) == null) break;
                    ((UserTO)anyTO).setMustChangePassword(BooleanUtils.toBoolean((String)values.get(0).toString()));
                    break;
                }
                case "userOwner": 
                case "groupOwner": {
                    if (!(anyTO instanceof GroupTO) || attr == null) break;
                    AttrTO attrTO = new AttrTO();
                    attrTO.setSchema("");
                    if (values.isEmpty() || values.get(0) == null) {
                        attrTO.getValues().add("");
                    } else {
                        attrTO.getValues().add(values.get(0).toString());
                    }
                    ((GroupTO)anyTO).getPlainAttrs().add(attrTO);
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null && attr != null) {
            GroupableRelatableTO groupableTO = null;
            Group group = null;
            if (anyTO instanceof GroupableRelatableTO && intAttrName.getMembershipOfGroup() != null) {
                groupableTO = (GroupableRelatableTO)anyTO;
                group = this.groupDAO.findByName(intAttrName.getMembershipOfGroup());
            }
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    AttrTO attrTO = new AttrTO();
                    attrTO.setSchema(intAttrName.getSchemaName());
                    PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(intAttrName.getSchemaName());
                    for (Object value : values) {
                        AttrSchemaType schemaType;
                        AttrSchemaType attrSchemaType = schemaType = schema == null ? AttrSchemaType.String : schema.getType();
                        if (value == null) continue;
                        if (schemaType == AttrSchemaType.Binary) {
                            attrTO.getValues().add(Base64.encode((byte[])((byte[])value)));
                            continue;
                        }
                        attrTO.getValues().add(value.toString());
                    }
                    if (groupableTO == null || group == null) {
                        anyTO.getPlainAttrs().add(attrTO);
                        break;
                    }
                    MembershipTO membership = groupableTO.getMembership(group.getKey());
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(group.getKey(), group.getName()).build();
                        groupableTO.getMemberships().add(membership);
                    }
                    membership.getPlainAttrs().add(attrTO);
                    break;
                }
                case DERIVED: {
                    AttrTO attrTO = new AttrTO();
                    attrTO.setSchema(intAttrName.getSchemaName());
                    if (groupableTO == null || group == null) {
                        anyTO.getDerAttrs().add(attrTO);
                        break;
                    }
                    MembershipTO membership = groupableTO.getMembership(group.getKey());
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(group.getKey(), group.getName()).build();
                        groupableTO.getMemberships().add(membership);
                    }
                    membership.getDerAttrs().add(attrTO);
                    break;
                }
                case VIRTUAL: {
                    AttrTO attrTO = new AttrTO();
                    attrTO.setSchema(intAttrName.getSchemaName());
                    for (Object value : attr.getValue() == null ? Collections.emptyList() : attr.getValue()) {
                        if (value == null) continue;
                        attrTO.getValues().add(value.toString());
                    }
                    if (groupableTO == null || group == null) {
                        anyTO.getVirAttrs().add(attrTO);
                        break;
                    }
                    MembershipTO membership = groupableTO.getMembership(group.getKey());
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(group.getKey(), group.getName()).build();
                        groupableTO.getMemberships().add(membership);
                    }
                    membership.getVirAttrs().add(attrTO);
                    break;
                }
            }
        }
    }

    public void setIntValues(Item orgUnitItem, Attribute attr, RealmTO realmTO) {
        List values = null;
        if (attr != null) {
            values = attr.getValue();
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(orgUnitItem)) {
                values = transformer.beforePull(orgUnitItem, (EntityTO)realmTO, values);
            }
        }
        if (values != null && !values.isEmpty() && values.get(0) != null) {
            switch (orgUnitItem.getIntAttrName()) {
                case "name": {
                    realmTO.setName(values.get(0).toString());
                    break;
                }
                case "fullpath": {
                    String parentFullPath = StringUtils.substringBeforeLast((String)values.get(0).toString(), (String)"/");
                    Realm parent = this.realmDAO.findByFullPath(parentFullPath);
                    if (parent == null) {
                        LOG.warn("Could not find Realm with path {}, ignoring", (Object)parentFullPath);
                        break;
                    }
                    realmTO.setParent(parent.getFullPath());
                    break;
                }
            }
        }
    }
}

