/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.pushpull.ReconciliationFilterBuilder;
import org.apache.syncope.core.provisioning.api.utils.ConnPoolConfUtils;
import org.apache.syncope.core.provisioning.java.AsyncConnectorFacade;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;

public class ConnectorFacadeProxy
implements Connector {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorFacadeProxy.class);
    private static final Integer DEFAULT_PAGE_SIZE = 100;
    private final ConnectorFacade connector;
    private final ConnInstance connInstance;
    @Autowired
    private AsyncConnectorFacade asyncFacade;

    public ConnectorFacadeProxy(ConnInstance connInstance) {
        this.connInstance = connInstance;
        ConnIdBundleManager connIdBundleManager = (ConnIdBundleManager)ApplicationContextProvider.getBeanFactory().getBean(ConnIdBundleManager.class);
        ConnectorInfo info = (ConnectorInfo)connIdBundleManager.getConnectorInfo(connInstance).getRight();
        APIConfiguration apiConfig = info.createDefaultAPIConfiguration();
        apiConfig.getResultsHandlerConfiguration().setFilteredResultsHandlerInValidationMode(true);
        ConfigurationProperties properties = apiConfig.getConfigurationProperties();
        for (ConnConfProperty property : connInstance.getConf()) {
            if (property.getValues() == null || property.getValues().isEmpty()) continue;
            properties.setPropertyValue(property.getSchema().getName(), this.getPropertyValue(property.getSchema().getType(), property.getValues()));
        }
        if (connInstance.getPoolConf() != null) {
            if (apiConfig.isConnectorPoolingSupported()) {
                ConnPoolConfUtils.updateObjectPoolConfiguration((ObjectPoolConfiguration)apiConfig.getConnectorPoolConfiguration(), (ConnPoolConf)connInstance.getPoolConf());
            } else {
                LOG.warn("Connector pooling not supported for {}", (Object)info);
            }
        }
        this.connector = ConnectorFacadeFactory.getInstance().newInstance(apiConfig);
        this.connector.validate();
    }

    public Uid authenticate(String username, String password, OperationOptions options) {
        Uid result = null;
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.AUTHENTICATE)) {
            Future<Uid> future = this.asyncFacade.authenticate(this.connector, username, new GuardedString(password.toCharArray()), options);
            try {
                result = future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
            }
            catch (java.util.concurrent.TimeoutException e) {
                future.cancel(true);
                throw new TimeoutException("Request timeout");
            }
            catch (Exception e) {
                LOG.error("Connector request execution failure", (Throwable)e);
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            LOG.info("Authenticate was attempted, although the connector only has these capabilities: {}. No action.", (Object)this.connInstance.getCapabilities());
        }
        return result;
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> attrs, OperationOptions options, AtomicReference<Boolean> propagationAttempted) {
        Uid result = null;
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.CREATE)) {
            propagationAttempted.set(true);
            Future<Uid> future = this.asyncFacade.create(this.connector, objectClass, attrs, options);
            try {
                result = future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
            }
            catch (java.util.concurrent.TimeoutException e) {
                future.cancel(true);
                throw new TimeoutException("Request timeout");
            }
            catch (Exception e) {
                LOG.error("Connector request execution failure", (Throwable)e);
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            LOG.info("Create was attempted, although the connector only has these capabilities: {}. No action.", (Object)this.connInstance.getCapabilities());
        }
        return result;
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options, AtomicReference<Boolean> propagationAttempted) {
        Uid result = null;
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.UPDATE)) {
            propagationAttempted.set(true);
            Future<Uid> future = this.asyncFacade.update(this.connector, objectClass, uid, attrs, options);
            try {
                result = future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
            }
            catch (java.util.concurrent.TimeoutException e) {
                future.cancel(true);
                throw new TimeoutException("Request timeout");
            }
            catch (Exception e) {
                LOG.error("Connector request execution failure", (Throwable)e);
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            LOG.info("Update for {} was attempted, although the connector only has these capabilities: {}. No action.", (Object)uid.getUidValue(), (Object)this.connInstance.getCapabilities());
        }
        return result;
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options, AtomicReference<Boolean> propagationAttempted) {
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.DELETE)) {
            propagationAttempted.set(true);
            Future<Uid> future = this.asyncFacade.delete(this.connector, objectClass, uid, options);
            try {
                future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
            }
            catch (java.util.concurrent.TimeoutException e) {
                future.cancel(true);
                throw new TimeoutException("Request timeout");
            }
            catch (Exception e) {
                LOG.error("Connector request execution failure", (Throwable)e);
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            LOG.info("Delete for {} was attempted, although the connector only has these capabilities: {}. No action.", (Object)uid.getUidValue(), (Object)this.connInstance.getCapabilities());
        }
    }

    @Transactional
    public void sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.SYNC)) {
            this.connector.sync(objectClass, token, handler, options);
        } else {
            LOG.info("Sync was attempted, although the connector only has these capabilities: {}. No action.", (Object)this.connInstance.getCapabilities());
        }
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        SyncToken result = null;
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.SYNC)) {
            Future<SyncToken> future = this.asyncFacade.getLatestSyncToken(this.connector, objectClass);
            try {
                result = future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
            }
            catch (java.util.concurrent.TimeoutException e) {
                future.cancel(true);
                throw new TimeoutException("Request timeout");
            }
            catch (Exception e) {
                LOG.error("Connector request execution failure", (Throwable)e);
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            LOG.info("getLatestSyncToken was attempted, although the connector only has these capabilities: {}. No action.", (Object)this.connInstance.getCapabilities());
        }
        return result;
    }

    @Transactional
    public void fullReconciliation(ObjectClass objectClass, SyncResultsHandler handler, OperationOptions options) {
        this.filteredReconciliation(objectClass, null, handler, options);
    }

    @Transactional
    public void filteredReconciliation(ObjectClass objectClass, ReconciliationFilterBuilder filterBuilder, final SyncResultsHandler handler, OperationOptions options) {
        Filter filter = null;
        OperationOptions actualOptions = options;
        if (filterBuilder != null) {
            filter = filterBuilder.build();
            actualOptions = filterBuilder.build(actualOptions);
        }
        this.search(objectClass, filter, new SearchResultsHandler(){

            @Transactional
            public boolean handle(ConnectorObject obj) {
                return handler.handle(new SyncDeltaBuilder().setObject(obj).setUid(obj.getUid()).setDeltaType(SyncDeltaType.CREATE_OR_UPDATE).setToken(new SyncToken((Object)"")).build());
            }

            public void handleResult(SearchResult sr) {
            }
        }, actualOptions);
    }

    public Set<ObjectClassInfo> getObjectClassInfo() {
        Future<Set<ObjectClassInfo>> future = this.asyncFacade.getObjectClassInfo(this.connector);
        try {
            return future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            future.cancel(true);
            throw new TimeoutException("Request timeout");
        }
        catch (Exception e) {
            LOG.error("Connector request execution failure", (Throwable)e);
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public void validate() {
        Future<String> future = this.asyncFacade.test(this.connector);
        try {
            future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            future.cancel(true);
            throw new TimeoutException("Request timeout");
        }
        catch (Exception e) {
            LOG.error("Connector request execution failure", (Throwable)e);
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public void test() {
        Future<String> future = this.asyncFacade.test(this.connector);
        try {
            future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            future.cancel(true);
            throw new TimeoutException("Request timeout");
        }
        catch (Exception e) {
            LOG.error("Connector request execution failure", (Throwable)e);
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public ConnectorObject getObject(ObjectClass objectClass, Attribute connObjectKey, OperationOptions options) {
        Future<ConnectorObject> future = null;
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.SEARCH)) {
            future = this.asyncFacade.getObject(this.connector, objectClass, connObjectKey, options);
        } else {
            LOG.info("Search was attempted, although the connector only has these capabilities: {}. No action.", (Object)this.connInstance.getCapabilities());
        }
        try {
            return future == null ? null : future.get(this.connInstance.getConnRequestTimeout().intValue(), TimeUnit.SECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            future.cancel(true);
            throw new TimeoutException("Request timeout");
        }
        catch (Exception e) {
            LOG.error("Connector request execution failure", (Throwable)e);
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public SearchResult search(ObjectClass objectClass, Filter filter, final SearchResultsHandler handler, OperationOptions options) {
        SearchResult result = null;
        if (this.connInstance.getCapabilities().contains(ConnectorCapability.SEARCH)) {
            if (options.getPageSize() == null && options.getPagedResultsCookie() == null) {
                OperationOptionsBuilder builder = new OperationOptionsBuilder(options).setPageSize(DEFAULT_PAGE_SIZE).setPagedResultsOffset(Integer.valueOf(-1));
                final String[] cookies = new String[]{null};
                do {
                    if (cookies[0] != null) {
                        builder.setPagedResultsCookie(cookies[0]);
                    }
                    result = this.connector.search(objectClass, filter, (ResultsHandler)new SearchResultsHandler(){

                        public void handleResult(SearchResult result) {
                            handler.handleResult(result);
                            cookies[0] = result.getPagedResultsCookie();
                        }

                        public boolean handle(ConnectorObject connectorObject) {
                            return handler.handle(connectorObject);
                        }
                    }, builder.build());
                } while (cookies[0] != null);
            } else {
                result = this.connector.search(objectClass, filter, (ResultsHandler)handler, options);
            }
        } else {
            LOG.info("Search was attempted, although the connector only has these capabilities: {}. No action.", (Object)this.connInstance.getCapabilities());
        }
        return result;
    }

    public SearchResult search(ObjectClass objectClass, Filter filter, SearchResultsHandler handler, int pageSize, String pagedResultsCookie, List<OrderByClause> orderBy, OperationOptions options) {
        OperationOptionsBuilder builder = new OperationOptionsBuilder().setPageSize(Integer.valueOf(pageSize)).setPagedResultsOffset(Integer.valueOf(-1));
        if (pagedResultsCookie != null) {
            builder.setPagedResultsCookie(pagedResultsCookie);
        }
        builder.setSortKeys((List)CollectionUtils.collect(orderBy, (Transformer)new Transformer<OrderByClause, SortKey>(){

            public SortKey transform(OrderByClause clause) {
                return new SortKey(clause.getField(), clause.getDirection() == OrderByClause.Direction.ASC);
            }
        }, new ArrayList(orderBy.size())));
        builder.setAttributesToGet(options.getAttributesToGet());
        return this.search(objectClass, filter, handler, builder.build());
    }

    public ConnInstance getConnInstance() {
        return this.connInstance;
    }

    private Object getPropertyValue(String propType, List<?> values) {
        Object value = null;
        try {
            Class propertySchemaClass = ClassUtils.forName((String)propType, (ClassLoader)ClassUtils.getDefaultClassLoader());
            value = GuardedString.class.equals((Object)propertySchemaClass) ? new GuardedString(values.get(0).toString().toCharArray()) : (GuardedByteArray.class.equals((Object)propertySchemaClass) ? new GuardedByteArray((byte[])values.get(0)) : (Character.class.equals((Object)propertySchemaClass) || Character.TYPE.equals(propertySchemaClass) ? (values.get(0) == null || values.get(0).toString().isEmpty() ? null : Character.valueOf(values.get(0).toString().charAt(0))) : (Integer.class.equals((Object)propertySchemaClass) || Integer.TYPE.equals(propertySchemaClass) ? Integer.valueOf(Integer.parseInt(values.get(0).toString())) : (Long.class.equals((Object)propertySchemaClass) || Long.TYPE.equals(propertySchemaClass) ? Long.valueOf(Long.parseLong(values.get(0).toString())) : (Float.class.equals((Object)propertySchemaClass) || Float.TYPE.equals(propertySchemaClass) ? Float.valueOf(Float.parseFloat(values.get(0).toString())) : (Double.class.equals((Object)propertySchemaClass) || Double.TYPE.equals(propertySchemaClass) ? Double.valueOf(Double.parseDouble(values.get(0).toString())) : (Boolean.class.equals((Object)propertySchemaClass) || Boolean.TYPE.equals(propertySchemaClass) ? Boolean.valueOf(Boolean.parseBoolean(values.get(0).toString())) : (URI.class.equals((Object)propertySchemaClass) ? URI.create(values.get(0).toString()) : (File.class.equals((Object)propertySchemaClass) ? new File(values.get(0).toString()) : (String[].class.equals((Object)propertySchemaClass) ? values.toArray(new String[0]) : (values.get(0) == null ? null : values.get(0).toString())))))))))));
        }
        catch (Exception e) {
            LOG.error("Invalid ConnConfProperty specified: {} {}", new Object[]{propType, values, e});
        }
        return value;
    }

    public String toString() {
        return "ConnectorFacadeProxy{connector=" + this.connector + "\ncapabitilies=" + this.connInstance.getCapabilities() + '}';
    }
}

