/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.oauth2.provider.DefaultEHCacheOAuthDataProvider;

public final class EHCacheUtil {
    private static Method cacheManagerCreateMethodNoArg;
    private static Method cacheManagerCreateMethodConfigurationArg;

    private EHCacheUtil() {
    }

    public static CacheConfiguration getCacheConfiguration(String key, CacheManager cacheManager) {
        CacheConfiguration cc = (CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(key);
        if (cc == null && key.contains("-")) {
            cc = (CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(key.substring(0, key.lastIndexOf(45) - 1));
        }
        if (cc == null) {
            cc = cacheManager.getConfiguration().getDefaultCacheConfiguration();
        }
        cc = cc == null ? new CacheConfiguration() : cc.clone();
        cc.setName(key);
        return cc;
    }

    public static CacheManager createCacheManager() throws CacheException {
        try {
            return (CacheManager)cacheManagerCreateMethodNoArg.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static CacheManager createCacheManager(Configuration conf) throws CacheException {
        try {
            return (CacheManager)cacheManagerCreateMethodConfigurationArg.invoke(null, conf);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static CacheManager createCacheManager(String configFile, Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, DefaultEHCacheOAuthDataProvider.class, (Bus)bus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CacheManager cacheManager = null;
        if (configFileURL == null) {
            cacheManager = EHCacheUtil.createCacheManager();
        } else {
            Configuration conf = ConfigurationFactory.parseConfiguration((URL)configFileURL);
            if (bus != null) {
                conf.setName(bus.getId());
                DiskStoreConfiguration dsc = conf.getDiskStoreConfiguration();
                if (dsc != null && "java.io.tmpdir".equals(dsc.getOriginalPath())) {
                    String path = conf.getDiskStoreConfiguration().getPath() + File.separator + bus.getId();
                    conf.getDiskStoreConfiguration().setPath(path);
                }
            }
            cacheManager = EHCacheUtil.createCacheManager(conf);
        }
        return cacheManager;
    }

    static {
        try {
            cacheManagerCreateMethodNoArg = CacheManager.class.getMethod("newInstance", null);
            cacheManagerCreateMethodConfigurationArg = CacheManager.class.getMethod("newInstance", Configuration.class);
        }
        catch (NoSuchMethodException e) {
            try {
                cacheManagerCreateMethodNoArg = CacheManager.class.getMethod("create", null);
                cacheManagerCreateMethodConfigurationArg = CacheManager.class.getMethod("create", Configuration.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

