/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.client.cli.view.Table;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;

public class UserResultManager
extends CommonsResultManager {
    public void printUsers(List<UserTO> userTOs) {
        System.out.println("");
        for (UserTO userTO : userTOs) {
            this.printUser(userTO);
        }
    }

    private void printUser(UserTO userTO) {
        System.out.println(" > USER KEY: " + userTO.getKey());
        System.out.println("    username: " + userTO.getUsername());
        System.out.println("    realm: " + userTO.getRealm());
        System.out.println("    status: " + userTO.getStatus());
        System.out.println("    RESOURCES: ");
        this.printResource(userTO.getResources());
        System.out.println("    ROLES: ");
        this.printRole(userTO.getRoles());
        System.out.println("    creation date: " + userTO.getCreationDate());
        System.out.println("    change password date: " + userTO.getChangePwdDate());
        System.out.println("    PLAIN ATTRIBUTES: ");
        this.printAttributes(userTO.getPlainAttrs());
        System.out.println("    DERIVED ATTRIBUTES: ");
        this.printAttributes(userTO.getDerAttrs());
        System.out.println("    VIRTUAL ATTRIBUTES: ");
        this.printAttributes(userTO.getVirAttrs());
        System.out.println("    creator: " + userTO.getCreator());
        System.out.println("    last modifier: " + userTO.getLastModifier());
        System.out.println("    token: " + userTO.getToken());
        System.out.println("    token expiration time: " + userTO.getTokenExpireTime());
        System.out.println("    last change: " + userTO.getLastChangeDate());
        System.out.println("    last login: " + userTO.getLastLoginDate());
        System.out.println("    failed logins: " + userTO.getFailedLogins());
        System.out.println("RELATIONSHIPS:");
        this.printRelationships(userTO.getRelationships());
        System.out.println("    security question key: " + userTO.getSecurityQuestion());
        System.out.println("    security question answer key: " + userTO.getSecurityAnswer());
        System.out.println("");
    }

    private void printResource(Set<String> resources) {
        for (String resource : resources) {
            System.out.println("       - " + resource);
        }
    }

    private void printRole(List<String> roles) {
        for (String role : roles) {
            System.out.println("       - " + role);
        }
    }

    private void printAttributes(Set<AttrTO> derAttrTOs) {
        for (AttrTO attrTO : derAttrTOs) {
            StringBuilder attributeSentence = new StringBuilder();
            attributeSentence.append("       ").append(attrTO.getSchema()).append(": ").append(attrTO.getValues());
            System.out.println(attributeSentence);
        }
    }

    private void printRelationships(List<RelationshipTO> relationshipTOs) {
        for (RelationshipTO relationshipTO : relationshipTOs) {
            System.out.println("       type: " + relationshipTO.getType());
        }
    }

    public void printFailedUsers(Map<String, String> users) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder("Users not deleted").header("user key").header("cause");
        for (Map.Entry<String, String> entrySet : users.entrySet()) {
            tableBuilder.rowValues(Arrays.asList(entrySet.getKey(), entrySet.getValue()));
        }
        tableBuilder.build().print();
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("users details", details);
    }
}

