/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.client.cli.view.Table;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;

public class SchemaResultManager
extends CommonsResultManager {
    public void toView(String schemaTypeString, List<? extends SchemaTO> schemaTOs) {
        switch (SchemaType.valueOf((String)schemaTypeString)) {
            case PLAIN: {
                this.printPlainSchemasDetailed(schemaTOs);
                break;
            }
            case DERIVED: {
                this.fromListDerived(schemaTOs);
                break;
            }
            case VIRTUAL: {
                this.fromListVirtual(schemaTOs);
                break;
            }
        }
    }

    private void printPlainSchemasDetailed(List<? extends SchemaTO> schemaTOs) {
        System.out.println("");
        for (SchemaTO schemaTO : schemaTOs) {
            this.printPlanSchemaDetailed((PlainSchemaTO)schemaTO);
        }
    }

    private void printPlanSchemaDetailed(PlainSchemaTO schemaTO) {
        System.out.println(" > SCHEMA KEY: " + schemaTO.getKey());
        System.out.println("    type: " + schemaTO.getType().toString());
        System.out.println("    any type class: " + schemaTO.getAnyTypeClass());
        System.out.println("    conversion pattern: " + schemaTO.getConversionPattern());
        System.out.println("    mandatory condition: " + schemaTO.getMandatoryCondition());
        System.out.println("    mime type: " + schemaTO.getMimeType());
        System.out.println("    validator class: " + schemaTO.getValidatorClass());
        System.out.println("    cipher algorithm: " + (schemaTO.getCipherAlgorithm() == null ? "" : schemaTO.getCipherAlgorithm().getAlgorithm()));
        System.out.println("");
    }

    public void printPlainSchemas(List<? extends SchemaTO> schemaTOs) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder("plain schemas").header("schema key").header("type").header("mandatory");
        for (SchemaTO schemaTO : schemaTOs) {
            tableBuilder.rowValues(Arrays.asList(((PlainSchemaTO)schemaTO).getKey(), ((PlainSchemaTO)schemaTO).getType().toString(), ((PlainSchemaTO)schemaTO).getMandatoryCondition()));
        }
        tableBuilder.build().print();
    }

    public void fromListDerived(List<? extends SchemaTO> schemaTOs) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder("derived schemas").header("schema key").header("expression");
        for (SchemaTO schemaTO : schemaTOs) {
            tableBuilder.rowValues(Arrays.asList(((DerSchemaTO)schemaTO).getKey(), ((DerSchemaTO)schemaTO).getExpression()));
        }
        tableBuilder.build().print();
    }

    public void fromListVirtual(List<? extends SchemaTO> schemaTOs) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder("virtual schemas").header("schema key").header("readonly");
        for (SchemaTO schemaTO : schemaTOs) {
            tableBuilder.rowValues(Arrays.asList(((VirSchemaTO)schemaTO).getKey(), String.valueOf(((VirSchemaTO)schemaTO).isReadonly())));
        }
        tableBuilder.build().print();
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("Schemas details", details);
    }
}

