/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.info;

import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.cli.commands.info.InfoResultManager;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Info {
    private static final Logger LOG = LoggerFactory.getLogger(Info.class);
    private final PlatformInfo platformInfo = SyncopeServices.get(SyncopeService.class).platform();
    private final InfoResultManager infoResultManager = new InfoResultManager();

    public void version() {
        try {
            this.infoResultManager.printVersion(this.platformInfo.getVersion());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void pwdResetAllowed() {
        try {
            this.infoResultManager.printPwdResetAllowed(this.platformInfo.isPwdResetAllowed());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void resetWithSecurityQuestion() {
        try {
            this.infoResultManager.printPwdResetRequiringSecurityQuestions(this.platformInfo.isPwdResetRequiringSecurityQuestions());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void selfRegistrationAllowed() {
        try {
            this.infoResultManager.printSelfRegistrationAllowed(this.platformInfo.isSelfRegAllowed());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void provisioningManager() {
        try {
            this.infoResultManager.printProvisioningManager(this.platformInfo.getAnyObjectProvisioningManager(), this.platformInfo.getUserProvisioningManager(), this.platformInfo.getGroupProvisioningManager());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void workflowAdapter() {
        try {
            this.infoResultManager.printWorkflowAdapter(this.platformInfo.getAnyObjectWorkflowAdapter(), this.platformInfo.getUserWorkflowAdapter(), this.platformInfo.getGroupWorkflowAdapter());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void accountRules() {
        try {
            this.infoResultManager.printAccountRules(this.platformInfo.getAccountRules());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void connidLocations() {
        try {
            this.infoResultManager.printConnidLocations(this.platformInfo.getConnIdLocations());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void reconciliationFilterBuilders() {
        try {
            this.infoResultManager.printReconciliationFilterBuilders(this.platformInfo.getReconciliationFilterBuilders());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void logicActions() {
        try {
            this.infoResultManager.printLogicActions(this.platformInfo.getLogicActions());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void mappingItemTransformers() {
        try {
            this.infoResultManager.printMappingItemTransformers(this.platformInfo.getItemTransformers());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void passwordRules() {
        try {
            this.infoResultManager.printPasswordRules(this.platformInfo.getPasswordRules());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void propagationActions() {
        try {
            this.infoResultManager.printPropagationActions(this.platformInfo.getPropagationActions());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void pushActions() {
        try {
            this.infoResultManager.printPushActions(this.platformInfo.getPushActions());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void pushCorrelationActions() {
        try {
            this.infoResultManager.printCorrelationActions(this.platformInfo.getPushCorrelationRules());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void reportletConfs() {
        try {
            this.infoResultManager.printReportletConfs(this.platformInfo.getReportletConfs());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void pullActions() {
        try {
            this.infoResultManager.printPullActions(this.platformInfo.getPullActions());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void pullCorrelationRules() {
        try {
            this.infoResultManager.printCorrelationRules(this.platformInfo.getPullCorrelationRules());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void taskJobs() {
        try {
            this.infoResultManager.printJobs(this.platformInfo.getTaskJobs());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void validators() {
        try {
            this.infoResultManager.printValidators(this.platformInfo.getValidators());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void passwordGenerators() {
        try {
            this.infoResultManager.printPasswordGenerator(this.platformInfo.getPasswordGenerator());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void virAttrCache() {
        try {
            this.infoResultManager.printVirtualAttributeCacheClass(this.platformInfo.getVirAttrCache());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }
}

