/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers;

import java.util.ArrayList;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.DocTypeRule;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.SyncopeTagRule;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.TagRule;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class HTMLPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String HTML_DEFAULT = "__html_default";
    public static final String HTML_COMMENT = "__html_comment";
    public static final String HTML_TAG = "__html_tag";
    public static final String HTML_SCRIPT = "__html_script";
    public static final String HTML_DOCTYPE = "__html_doctype";
    public static final String HTML_DIRECTIVE = "__html_directive";
    public static final String JAVASCRIPT = "__html_javascript";
    public static final String HTML_CSS = "__html_css";
    public static final String PREFIX_TAG = "__prefix_tag";
    public static final String SYNCOPE_TAG = "__syncope_tag";

    public HTMLPartitionScanner() {
        Token htmlComment = new Token((Object)HTML_COMMENT);
        Token htmlTag = new Token((Object)HTML_TAG);
        Token prefixTag = new Token((Object)PREFIX_TAG);
        Token htmlScript = new Token((Object)HTML_SCRIPT);
        Token htmlDoctype = new Token((Object)HTML_DOCTYPE);
        Token htmlDirective = new Token((Object)HTML_DIRECTIVE);
        Token javaScript = new Token((Object)JAVASCRIPT);
        Token htmlCss = new Token((Object)HTML_CSS);
        Token syncopeTag = new Token((Object)SYNCOPE_TAG);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule(" <!--", "-->", (IToken)htmlComment));
        rules.add(new MultiLineRule(" <%--", "--%>", (IToken)htmlComment));
        rules.add((Object)new DocTypeRule((IToken)htmlDoctype));
        rules.add(new MultiLineRule(" <%@", "%>", (IToken)htmlDirective));
        rules.add(new MultiLineRule(" <%", "%>", (IToken)htmlScript));
        rules.add(new MultiLineRule(" <![CDATA[", "]]>", (IToken)htmlDoctype));
        rules.add(new MultiLineRule(" <?xml", "?>", (IToken)htmlDoctype));
        rules.add(new MultiLineRule(" <script", " </script>", (IToken)javaScript));
        rules.add(new MultiLineRule(" <style", " </style>", (IToken)htmlCss));
        rules.add(new EndOfLineRule("$$", (IToken)syncopeTag));
        rules.add((Object)new TagRule((IToken)prefixTag, 0));
        rules.add((Object)new TagRule((IToken)htmlTag, 1));
        rules.add((Object)new SyncopeTagRule((IToken)syncopeTag, 0));
        rules.add((Object)new SyncopeTagRule((IToken)syncopeTag, 1));
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
    }
}

