/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.syncope.common.rest.api.service.OIDCProviderService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="oidcProviders", path="/api/oidcProviders")
public class OIDCProvidersResource
extends BaseResource {
    private static final long serialVersionUID = -6595407257133697170L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        response.setTextEncoding(StandardCharsets.UTF_8.name());
        try {
            final ArrayNode result = MAPPER.createArrayNode();
            for (OIDCProviderTO op : ((OIDCProviderService)SyncopeEnduserSession.get().getService(OIDCProviderService.class)).list()) {
                ObjectNode opNode = MAPPER.createObjectNode();
                opNode.put("name", op.getName());
                result.add((JsonNode)opNode);
            }
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)result));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving available OIDC Providers", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + "}}");
        }
        return response;
    }
}

