/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.SAML2LoginResponseTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.saml2.SAML2IdPEntity;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.SAML2IdPActions;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SAML2UserManager {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2UserManager.class);
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private IntAttrNameParser intAttrNameParser;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private TemplateUtils templateUtils;
    @Autowired
    private UserProvisioningManager provisioningManager;
    @Autowired
    private UserDataBinder binder;

    @Transactional(readOnly=true)
    public List<String> findMatchingUser(String keyValue, ItemTO connObjectKeyItem) {
        IntAttrName intAttrName;
        ArrayList<String> result = new ArrayList<String>();
        String transformed = keyValue;
        for (ItemTransformer transformer : MappingUtils.getItemTransformers((ItemTO)connObjectKeyItem)) {
            List output = transformer.beforePull(null, null, Collections.singletonList(transformed));
            if (output == null || output.isEmpty()) continue;
            transformed = output.get(0).toString();
        }
        try {
            intAttrName = this.intAttrNameParser.parse(connObjectKeyItem.getIntAttrName(), AnyTypeKind.USER);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)connObjectKeyItem.getIntAttrName(), (Object)e);
            return result;
        }
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "key": {
                    User byKey = (User)this.userDAO.find(transformed);
                    if (byKey == null) break;
                    result.add(byKey.getUsername());
                    break;
                }
                case "username": {
                    User byUsername = this.userDAO.findByUsername(transformed);
                    if (byUsername == null) break;
                    result.add(byUsername.getUsername());
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    PlainAttrValue value = (PlainAttrValue)this.entityFactory.newEntity(UPlainAttrValue.class);
                    PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(intAttrName.getSchemaName());
                    if (schema == null) {
                        value.setStringValue(transformed);
                    } else {
                        try {
                            value.parseValue(schema, transformed);
                        }
                        catch (ParsingValidationException e) {
                            LOG.error("While parsing provided key value {}", (Object)transformed, (Object)e);
                            value.setStringValue(transformed);
                        }
                    }
                    CollectionUtils.collect((Iterable)this.userDAO.findByPlainAttrValue(intAttrName.getSchemaName(), value), (Transformer)new Transformer<User, String>(){

                        public String transform(User input) {
                            return input.getUsername();
                        }
                    }, result);
                    break;
                }
                case DERIVED: {
                    CollectionUtils.collect((Iterable)this.userDAO.findByDerAttrValue(intAttrName.getSchemaName(), transformed), (Transformer)new Transformer<User, String>(){

                        public String transform(User input) {
                            return input.getUsername();
                        }
                    }, result);
                    break;
                }
            }
        }
        return result;
    }

    private List<SAML2IdPActions> getActions(SAML2IdPEntity idp) {
        ArrayList<SAML2IdPActions> actions = new ArrayList<SAML2IdPActions>();
        for (String className : idp.getActionsClassNames()) {
            try {
                Class<?> actionsClass = Class.forName(className);
                SAML2IdPActions idpActions = (SAML2IdPActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(idpActions);
            }
            catch (Exception e) {
                LOG.warn("Class '{}' not found", (Object)className, (Object)e);
            }
        }
        return actions;
    }

    public void fill(SAML2IdPEntity idp, SAML2LoginResponseTO responseTO, UserTO userTO) {
        block11: for (ItemTO item : idp.getItems()) {
            List values = Collections.emptyList();
            AttrTO samlAttr = responseTO.getAttr(item.getExtAttrName());
            if (samlAttr != null && !samlAttr.getValues().isEmpty()) {
                values = samlAttr.getValues();
                List transformed = new ArrayList(values);
                for (ItemTransformer transformer : MappingUtils.getItemTransformers((ItemTO)item)) {
                    transformed = transformer.beforePull(null, (EntityTO)userTO, transformed);
                }
                values.clear();
                for (Object value : transformed) {
                    values.add(value.toString());
                }
            }
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), AnyTypeKind.USER);
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
            }
            if (intAttrName != null && intAttrName.getField() != null) {
                switch (intAttrName.getField()) {
                    case "username": {
                        if (values.isEmpty()) continue block11;
                        userTO.setUsername((String)values.get(0));
                        break;
                    }
                    default: {
                        LOG.warn("Unsupported: {}", (Object)intAttrName.getField());
                        break;
                    }
                }
                continue;
            }
            if (intAttrName == null || intAttrName.getSchemaType() == null) continue;
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    AttrTO attr = userTO.getPlainAttr(intAttrName.getSchemaName());
                    if (attr == null) {
                        attr = new AttrTO.Builder().schema(intAttrName.getSchemaName()).build();
                        userTO.getPlainAttrs().add(attr);
                    }
                    attr.getValues().clear();
                    attr.getValues().addAll(values);
                    continue block11;
                }
            }
            LOG.warn("Unsupported: {} {}", (Object)intAttrName.getSchemaType(), (Object)intAttrName.getSchemaName());
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String create(SAML2IdPEntity idp, SAML2LoginResponseTO responseTO, String nameID) {
        UserTO userTO = new UserTO();
        if (idp.getUserTemplate() != null) {
            this.templateUtils.apply((AnyTO)userTO, (AnyTO)idp.getUserTemplate());
        }
        List<SAML2IdPActions> actions = this.getActions(idp);
        for (SAML2IdPActions action : actions) {
            userTO = action.beforeCreate(userTO, responseTO);
        }
        this.fill(idp, responseTO, userTO);
        if (userTO.getRealm() == null) {
            userTO.setRealm("/");
        }
        if (userTO.getUsername() == null) {
            userTO.setUsername(nameID);
        }
        Pair created = this.provisioningManager.create(userTO, false, false);
        userTO = this.binder.getUserTO((String)created.getKey());
        for (SAML2IdPActions action : actions) {
            userTO = action.afterCreate(userTO, responseTO);
        }
        return userTO.getUsername();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String update(String username, SAML2IdPEntity idp, SAML2LoginResponseTO responseTO) {
        UserTO userTO = this.binder.getUserTO(this.userDAO.findKey(username));
        UserTO original = (UserTO)SerializationUtils.clone((Serializable)userTO);
        this.fill(idp, responseTO, userTO);
        UserPatch userPatch = AnyOperations.diff((UserTO)userTO, (UserTO)original, (boolean)true);
        List<SAML2IdPActions> actions = this.getActions(idp);
        for (SAML2IdPActions action : actions) {
            userPatch = action.beforeUpdate(userPatch, responseTO);
        }
        Pair updated = this.provisioningManager.update((AnyPatch)userPatch, false);
        userTO = this.binder.getUserTO(((UserPatch)updated.getLeft()).getKey());
        for (SAML2IdPActions action : actions) {
            userTO = action.afterUpdate(userTO, responseTO);
        }
        return userTO.getUsername();
    }
}

