/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;

public abstract class AjaxFallbackButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final Form<?> mForm;

    public AjaxFallbackButton(String id, Form<?> form) {
        this(id, null, form);
    }

    public AjaxFallbackButton(String id, IModel<String> model, Form<?> form) {
        super(id, model);
        this.mForm = form;
        this.add(new AjaxFormSubmitBehavior(form, "click"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onSubmit(target, AjaxFallbackButton.this.getForm());
            }

            @Override
            protected void onAfterSubmit(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onAfterSubmit(target, AjaxFallbackButton.this.getForm());
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onError(target, AjaxFallbackButton.this.getForm());
            }

            @Override
            public boolean getDefaultProcessing() {
                return AjaxFallbackButton.this.getDefaultFormProcessing();
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setPreventDefault(true);
                AjaxFallbackButton.this.updateAjaxAttributes(attributes);
            }
        });
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected void onError(AjaxRequestTarget target, Form<?> form) {
    }

    @Override
    public final void onError() {
        if (this.getRequestCycle().find(AjaxRequestTarget.class) == null) {
            this.onError(null, this.getForm());
        }
    }

    @Override
    public final void onSubmit() {
        if (this.getRequestCycle().find(AjaxRequestTarget.class) == null) {
            this.onSubmit(null, this.getForm());
        }
    }

    @Override
    public final void onAfterSubmit() {
        if (this.getRequestCycle().find(AjaxRequestTarget.class) == null) {
            this.onAfterSubmit(null, this.getForm());
        }
    }

    @Override
    public Form<?> getForm() {
        return this.mForm == null ? super.getForm() : this.mForm;
    }

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected final boolean isButtonEnabled() {
        return this.isEnabledInHierarchy();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        String tagName = tag.getName();
        if (!"input".equalsIgnoreCase(tagName) && !"button".equalsIgnoreCase(tagName)) {
            String msg = String.format("%s must be used only with <input type=\"submit\"> or <input type=\"submit\"> markup elements. The fallback functionality doesn't work for other markup elements. Component path: %s, markup element: <%s>.", AjaxFallbackButton.class.getSimpleName(), this.getClassRelativePath(), tagName);
            this.findMarkupStream().throwMarkupException(msg);
        }
        super.onComponentTag(tag);
    }
}

