/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.cxf.common.util.StringUtils;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.DerAttrs;
import org.apache.syncope.client.console.wizards.any.PlainAttrs;
import org.apache.syncope.client.console.wizards.any.VirAttrs;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public abstract class AbstractAttrs<S extends SchemaTO>
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = -5387344116983102292L;
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();
    private final AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
    private final GroupRestClient groupRestClient = new GroupRestClient();
    protected final AnyTO anyTO;
    private final List<String> whichAttrs;
    protected final Map<String, S> schemas = new LinkedHashMap<String, S>();
    protected final Map<String, Map<String, S>> membershipSchemas = new LinkedHashMap<String, Map<String, S>>();
    protected final IModel<List<AttrTO>> attrTOs;
    protected final IModel<List<MembershipTO>> membershipTOs;
    private final List<String> anyTypeClasses;

    public AbstractAttrs(AnyWrapper<?> modelObject, List<String> anyTypeClasses, List<String> whichAttrs) {
        this.anyTypeClasses = anyTypeClasses;
        this.attrTOs = new ListModel(Collections.emptyList());
        this.membershipTOs = new ListModel(Collections.emptyList());
        this.setOutputMarkupId(true);
        this.anyTO = modelObject.getInnerObject();
        this.whichAttrs = whichAttrs;
    }

    private List<AttrTO> loadAttrTOs() {
        this.setSchemas((List)CollectionUtils.collect(this.anyTypeClassRestClient.list(this.anyTO.getAuxClasses()), (Transformer)EntityTOUtils.keyTransformer(), new ArrayList<String>(this.anyTypeClasses)));
        this.setAttrs();
        return this.getAttrsFromTO();
    }

    private List<MembershipTO> loadMembershipAttrTOs() {
        ArrayList<MembershipTO> memberships = new ArrayList<MembershipTO>();
        try {
            this.membershipSchemas.clear();
            for (MembershipTO membership : (List)PropertyResolver.getPropertyField((String)"memberships", (Object)this.anyTO).get(this.anyTO)) {
                this.setSchemas(membership.getGroupKey(), (List)CollectionUtils.collect(this.anyTypeClassRestClient.list(this.getMembershipAuxClasses(membership, this.anyTO.getType())), (Transformer)EntityTOUtils.keyTransformer(), new ArrayList()));
                this.setAttrs(membership);
                if (this instanceof PlainAttrs && !membership.getPlainAttrs().isEmpty()) {
                    memberships.add(membership);
                    continue;
                }
                if (this instanceof DerAttrs && !membership.getDerAttrs().isEmpty()) {
                    memberships.add(membership);
                    continue;
                }
                if (!(this instanceof VirAttrs) || membership.getVirAttrs().isEmpty()) continue;
                memberships.add(membership);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | WicketRuntimeException throwable) {
            // empty catch block
        }
        return memberships;
    }

    protected boolean reoderSchemas() {
        return !this.whichAttrs.isEmpty();
    }

    protected abstract SchemaType getSchemaType();

    private void setSchemas(String membership, List<String> anyTypeClasses) {
        Map<Object, Object> mscs;
        if (this.membershipSchemas.containsKey(membership)) {
            mscs = this.membershipSchemas.get(membership);
        } else {
            mscs = new LinkedHashMap();
            this.membershipSchemas.put(membership, mscs);
        }
        this.setSchemas(anyTypeClasses, mscs);
    }

    private void setSchemas(List<String> anyTypeClasses) {
        this.setSchemas(anyTypeClasses, this.schemas);
    }

    private void setSchemas(List<String> anyTypeClasses, Map<String, S> scs) {
        List<Object> allSchemas = anyTypeClasses.isEmpty() ? Collections.emptyList() : this.schemaRestClient.getSchemas(this.getSchemaType(), null, anyTypeClasses.toArray(new String[0]));
        scs.clear();
        if (this.reoderSchemas()) {
            CollectionUtils.filter(allSchemas, (Predicate)new Predicate<S>(){

                public boolean evaluate(S schemaTO) {
                    return AbstractAttrs.this.whichAttrs.contains(schemaTO.getKey());
                }
            });
        }
        for (SchemaTO schemaTO : allSchemas) {
            scs.put(schemaTO.getKey(), schemaTO);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (org.apache.cxf.common.util.CollectionUtils.isEmpty((Collection)((Collection)this.attrTOs.getObject())) && org.apache.cxf.common.util.CollectionUtils.isEmpty((Collection)((Collection)this.membershipTOs.getObject()))) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\"); $('#attributes').hide();", this.getString("attribute.empty.list"))));
        }
    }

    protected abstract void setAttrs();

    protected abstract void setAttrs(MembershipTO var1);

    protected abstract List<AttrTO> getAttrsFromTO();

    protected abstract List<AttrTO> getAttrsFromTO(MembershipTO var1);

    protected List<String> getMembershipAuxClasses(MembershipTO membershipTO, String anyType) {
        try {
            GroupTO groupTO = (GroupTO)this.groupRestClient.read(membershipTO.getGroupKey());
            return groupTO.getTypeExtension(anyType).getAuxClasses();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean evaluate() {
        this.attrTOs.setObject(this.loadAttrTOs());
        this.membershipTOs.setObject(this.loadMembershipAttrTOs());
        return CollectionUtils.isNotEmpty((Collection)((Collection)this.attrTOs.getObject())) || CollectionUtils.isNotEmpty((Collection)((Collection)this.membershipTOs.getObject()));
    }

    public PageReference getPageReference() {
        return null;
    }

    public class Schemas
    extends Panel {
        private static final long serialVersionUID = -2447602429647965090L;

        public Schemas(String id) {
            super(id);
        }
    }

    protected class AttrComparator
    implements Comparator<AttrTO>,
    Serializable {
        private static final long serialVersionUID = -5105030477767941060L;

        protected AttrComparator() {
        }

        @Override
        public int compare(AttrTO left, AttrTO right) {
            if (left == null || StringUtils.isEmpty((String)left.getSchema())) {
                return -1;
            }
            if (right == null || StringUtils.isEmpty((String)right.getSchema())) {
                return 1;
            }
            if (AbstractAttrs.this.reoderSchemas()) {
                int rightIndex;
                int leftIndex = AbstractAttrs.this.whichAttrs.indexOf(left.getSchema());
                if (leftIndex > (rightIndex = AbstractAttrs.this.whichAttrs.indexOf(right.getSchema()))) {
                    return 1;
                }
                if (leftIndex < rightIndex) {
                    return -1;
                }
                return 0;
            }
            return left.getSchema().compareTo(right.getSchema());
        }
    }
}

