/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.wicket.ajax.markup.html.IndicatorAjaxLink;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionPanel;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.syncope.client.console.widgets.ProgressBean;
import org.apache.syncope.client.console.widgets.ProgressesPanel;
import org.apache.syncope.client.console.widgets.ReconDetailsModalPanel;
import org.apache.syncope.client.console.widgets.reconciliation.Any;
import org.apache.syncope.client.console.widgets.reconciliation.Anys;
import org.apache.syncope.client.console.widgets.reconciliation.Misaligned;
import org.apache.syncope.client.console.widgets.reconciliation.Missing;
import org.apache.syncope.client.console.widgets.reconciliation.ReconciliationReport;
import org.apache.syncope.client.console.widgets.reconciliation.ReconciliationReportParser;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconciliationWidget
extends BaseWidget {
    private static final long serialVersionUID = -816175678514035085L;
    private static final Logger LOG = LoggerFactory.getLogger(ReconciliationWidget.class);
    private static final int ROWS = 10;
    private final String reconciliationReportKey;
    private final BaseModal<Any> detailsModal = new BaseModal("detailsModal");
    private final PageReference pageRef;
    private final ReportRestClient restClient = new ReportRestClient();
    private final WebMarkupContainer container;
    private final WebMarkupContainer overlay;
    private boolean checkReconciliationJob = false;

    public ReconciliationWidget(String id, final PageReference pageRef) {
        super(id);
        this.pageRef = pageRef;
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.detailsModal});
        this.container = new WebMarkupContainer("reconciliationContainer");
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)10)){
            private static final long serialVersionUID = 7298597675929755960L;

            protected void onTimer(AjaxRequestTarget target) {
                if (ReconciliationWidget.this.isCheckReconciliationJob()) {
                    try {
                        JobTO reportJobTO = (JobTO)IterableUtils.find(ReconciliationWidget.this.restClient.listJobs(), (Predicate)new Predicate<JobTO>(){

                            public boolean evaluate(JobTO jobTO) {
                                return SyncopeConsoleApplication.get().getReconciliationReportKey().equals(jobTO.getRefKey());
                            }
                        });
                        if (reportJobTO != null && !reportJobTO.isRunning()) {
                            LOG.debug("Report {} is not running", (Object)SyncopeConsoleApplication.get().getReconciliationReportKey());
                            ReconciliationWidget.this.overlay.setVisible(false);
                            ReconciliationWidget.this.container.addOrReplace(new Component[]{ReconciliationWidget.this.buildExecFragment()});
                            target.add(new Component[]{ReconciliationWidget.this});
                            ReconciliationWidget.this.setCheckReconciliationJob(false);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Unexpected error while checking for updated reconciliation job info", t);
                    }
                }
            }
        }});
        this.add(new Component[]{this.container});
        this.overlay = new WebMarkupContainer("overlay");
        this.overlay.setOutputMarkupPlaceholderTag(true);
        this.overlay.setVisible(false);
        this.container.add(new Component[]{this.overlay});
        this.reconciliationReportKey = SyncopeConsoleApplication.get().getReconciliationReportKey();
        ReportTO reconciliationReport = null;
        if (SyncopeConsoleSession.get().owns("REPORT_READ")) {
            try {
                reconciliationReport = this.restClient.read(this.reconciliationReportKey);
            }
            catch (Exception e) {
                LOG.error("Could not fetch the expected reconciliation report with key {}, aborting", (Object)this.reconciliationReportKey, (Object)e);
            }
        }
        Fragment reportResult = reconciliationReport == null || reconciliationReport.getExecutions().isEmpty() ? new Fragment("reportResult", "noExecFragment", (MarkupContainer)this) : this.buildExecFragment();
        reportResult.setOutputMarkupId(true);
        this.container.add(new Component[]{reportResult});
        IndicatorAjaxLink<Void> refresh = new IndicatorAjaxLink<Void>("refresh"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    ReconciliationWidget.this.restClient.startExecution(ReconciliationWidget.this.reconciliationReportKey, null);
                    ReconciliationWidget.this.overlay.setVisible(true);
                    target.add(new Component[]{ReconciliationWidget.this});
                    ReconciliationWidget.this.setCheckReconciliationJob(true);
                    SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While starting reconciliation report", (Throwable)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)"Could not start reconciliation report"));
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)refresh, (Action)Component.RENDER, (String)"REPORT_EXECUTE");
        this.container.add(new Component[]{refresh});
    }

    private boolean isCheckReconciliationJob() {
        return this.checkReconciliationJob;
    }

    private void setCheckReconciliationJob(boolean checkReconciliationJob) {
        this.checkReconciliationJob = checkReconciliationJob;
    }

    private Fragment buildExecFragment() {
        Pair execResult;
        Fragment execFragment = new Fragment("reportResult", "execFragment", (MarkupContainer)this);
        execFragment.setOutputMarkupId(true);
        try {
            execResult = this.parseReconciliationReportExec();
        }
        catch (Exception e) {
            LOG.error("Could not parse the reconciliation report result", (Throwable)e);
            execResult = Pair.of(Collections.emptyList(), (Object)((Object)new ReconciliationReport(new Date())));
        }
        final List progressBeans = (List)execResult.getLeft();
        final ReconciliationReport report = (ReconciliationReport)((Object)execResult.getRight());
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new AbstractTab((IModel)new ResourceModel("summary")){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new ProgressesPanel(panelId, report.getRun(), progressBeans);
            }
        });
        tabs.add(new AbstractTab((IModel)Model.of((Serializable)((Object)AnyTypeKind.USER.name()))){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new AnysReconciliationPanel(panelId, report.getUsers(), ReconciliationWidget.this.pageRef);
            }
        });
        tabs.add(new AbstractTab((IModel)Model.of((Serializable)((Object)AnyTypeKind.GROUP.name()))){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new AnysReconciliationPanel(panelId, report.getGroups(), ReconciliationWidget.this.pageRef);
            }
        });
        for (final Anys anys : report.getAnyObjects()) {
            tabs.add(new AbstractTab((IModel)Model.of((Serializable)((Object)anys.getAnyType()))){
                private static final long serialVersionUID = -6815067322125799251L;

                public Panel getPanel(String panelId) {
                    return new AnysReconciliationPanel(panelId, anys, ReconciliationWidget.this.pageRef);
                }
            });
        }
        execFragment.add(new Component[]{new AjaxBootstrapTabbedPanel("execResult", tabs)});
        return execFragment;
    }

    private Pair<List<ProgressBean>, ReconciliationReport> parseReconciliationReportExec() throws IOException {
        List beans = Collections.emptyList();
        ReconciliationReport report = null;
        ExecTO exec = null;
        if (SyncopeConsoleSession.get().owns("REPORT_LIST")) {
            exec = (ExecTO)IterableUtils.find(this.restClient.listRecentExecutions(10), (Predicate)new Predicate<ExecTO>(){

                public boolean evaluate(ExecTO exec) {
                    return ReconciliationWidget.this.reconciliationReportKey.equals(exec.getRefKey());
                }
            });
        }
        if (exec == null) {
            LOG.error("Could not find the last execution of reconciliation report");
        } else {
            Object entity = this.restClient.exportExecutionResult(exec.getKey(), ReportExecExportFormat.XML).getEntity();
            if (entity instanceof InputStream) {
                try {
                    report = ReconciliationReportParser.parse(exec.getEnd(), (InputStream)entity);
                    beans = new ArrayList();
                    ProgressBean progressBean = new ProgressBean();
                    progressBean.setText(this.getString("users"));
                    progressBean.setTotal(report.getUsers().getTotal());
                    progressBean.setFraction(report.getUsers().getTotal() - report.getUsers().getAnys().size());
                    progressBean.setCssClass("progress-bar-yellow");
                    beans.add(progressBean);
                    progressBean = new ProgressBean();
                    progressBean.setText(this.getString("groups"));
                    progressBean.setTotal(report.getGroups().getTotal());
                    progressBean.setFraction(report.getGroups().getTotal() - report.getGroups().getAnys().size());
                    progressBean.setCssClass("progress-bar-red");
                    beans.add(progressBean);
                    int i = 0;
                    for (Anys anys : report.getAnyObjects()) {
                        progressBean = new ProgressBean();
                        progressBean.setText(anys.getAnyType());
                        progressBean.setTotal(anys.getTotal());
                        progressBean.setFraction(anys.getTotal() - anys.getAnys().size());
                        progressBean.setCssClass("progress-bar-" + (i % 2 == 0 ? "green" : "aqua"));
                        beans.add(progressBean);
                        ++i;
                    }
                }
                catch (Exception e) {
                    LOG.error("Could not parse the last execution available of reconciliation report", (Throwable)e);
                }
            }
        }
        return Pair.of(beans, (Object)((Object)(report == null ? new ReconciliationReport(new Date()) : report)));
    }

    protected final class AnysReconciliationProvider
    extends DirectoryDataProvider<Any> {
        private static final long serialVersionUID = -1500081449932597854L;
        private final Anys anys;
        private final SortableDataProviderComparator<Any> comparator;

        private AnysReconciliationProvider(Anys anys) {
            super(10);
            this.anys = anys;
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<Any>(this);
        }

        public Iterator<Any> iterator(long first, long count) {
            Collections.sort(this.anys.getAnys(), this.comparator);
            return this.anys.getAnys().subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.anys.getAnys().size();
        }

        public IModel<Any> model(Any object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    private class AnysReconciliationPanel
    extends DirectoryPanel<Any, Any, AnysReconciliationProvider, BaseRestClient> {
        private static final long serialVersionUID = -8214546246301342868L;
        private final Anys anys;

        AnysReconciliationPanel(String id, Anys anys, PageReference pageRef) {
            super(id, new DirectoryPanel.Builder<Any, Any, BaseRestClient>(null, pageRef){
                private static final long serialVersionUID = 8769126634538601689L;

                @Override
                protected WizardMgtPanel<Any> newInstance(String id, boolean wizardInModal) {
                    throw new UnsupportedOperationException();
                }
            }.disableCheckBoxes().hidePaginator());
            this.anys = anys;
            this.rows = 10;
            this.initResultTable();
        }

        @Override
        protected AnysReconciliationProvider dataProvider() {
            return new AnysReconciliationProvider(this.anys);
        }

        @Override
        protected String paginatorRowsKey() {
            return "";
        }

        @Override
        protected Collection<ActionLink.ActionType> getBulkActions() {
            return Collections.emptyList();
        }

        @Override
        protected List<IColumn<Any, String>> getColumns() {
            ArrayList<IColumn<Any, String>> columns = new ArrayList<IColumn<Any, String>>();
            columns.add((IColumn<Any, String>)new AbstractColumn<Any, String>((IModel)new ResourceModel("reference"), "key"){
                private static final long serialVersionUID = -1822504503325964706L;

                public void populateItem(Item<ICellPopulator<Any>> cellItem, String componentId, IModel<Any> rowModel) {
                    cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)(((Any)((Object)rowModel.getObject())).getKey() + (StringUtils.isBlank((CharSequence)((Any)((Object)rowModel.getObject())).getName()) ? "" : " " + ((Any)((Object)rowModel.getObject())).getName()))))});
                }
            });
            HashSet resources = new HashSet();
            for (Any any : this.anys.getAnys()) {
                resources.addAll(CollectionUtils.collect(any.getMissing(), (Transformer)new Transformer<Missing, String>(){

                    public String transform(Missing input) {
                        return input.getResource();
                    }
                }));
                resources.addAll(CollectionUtils.collect(any.getMisaligned(), (Transformer)new Transformer<Misaligned, String>(){

                    public String transform(Misaligned input) {
                        return input.getResource();
                    }
                }));
            }
            for (final String resource : resources) {
                columns.add((IColumn<Any, String>)new AbstractColumn<Any, String>((IModel)Model.of((Serializable)((Object)resource))){
                    private static final long serialVersionUID = -1822504503325964706L;

                    public void populateItem(Item<ICellPopulator<Any>> cellItem, String componentId, final IModel<Any> rowModel) {
                        Object content;
                        Any any = (Any)((Object)rowModel.getObject());
                        Missing missing = (Missing)((Object)IterableUtils.find(any.getMissing(), (Predicate)new Predicate<Missing>(){

                            public boolean evaluate(Missing object) {
                                return resource.equals(object.getResource());
                            }
                        }));
                        final List misaligned = (List)CollectionUtils.select(any.getMisaligned(), (Predicate)new Predicate<Misaligned>(){

                            public boolean evaluate(Misaligned object) {
                                return resource.equals(object.getResource());
                            }
                        }, new ArrayList());
                        if (missing == null) {
                            if (misaligned == null || misaligned.isEmpty()) {
                                content = new Label(componentId, (Serializable)((Object)""));
                            } else {
                                org.apache.syncope.client.console.wicket.markup.html.form.Action<Any> action = new org.apache.syncope.client.console.wicket.markup.html.form.Action<Any>(new ActionLink<Any>(){
                                    private static final long serialVersionUID = -3722207913631435501L;

                                    @Override
                                    public void onClick(AjaxRequestTarget target, Any ignore) {
                                        AnysReconciliationPanel.this.modal.header((IModel)Model.of((Serializable)((Object)(((Any)((Object)rowModel.getObject())).getType() + " " + ((Any)((Object)rowModel.getObject())).getKey() + " " + ((Any)((Object)rowModel.getObject())).getName()))));
                                        AnysReconciliationPanel.this.modal.setContent(new ReconDetailsModalPanel(AnysReconciliationPanel.this.modal, resource, misaligned, ReconciliationWidget.this.pageRef));
                                        AnysReconciliationPanel.this.modal.show(true);
                                        target.add(new Component[]{AnysReconciliationPanel.this.modal});
                                    }
                                }, ActionLink.ActionType.VIEW);
                                action.hideLabel();
                                content = new ActionPanel<Any>(componentId, rowModel, action);
                            }
                        } else {
                            org.apache.syncope.client.console.wicket.markup.html.form.Action action = new org.apache.syncope.client.console.wicket.markup.html.form.Action(null, ActionLink.ActionType.NOT_FOUND);
                            action.hideLabel();
                            content = new ActionPanel<Any>(componentId, rowModel, action);
                        }
                        cellItem.add(new Component[]{content});
                        cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"text-center"))});
                    }
                });
            }
            return columns;
        }
    }
}

