/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.WorkflowDefinitionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.service.WorkflowService;

public class WorkflowRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 5049285686167071017L;

    private WorkflowService getService(MediaType mediaType) {
        return SyncopeConsoleSession.get().getService(mediaType, WorkflowService.class);
    }

    public List<WorkflowDefinitionTO> getDefinitions() {
        return WorkflowRestClient.getService(WorkflowService.class).list(AnyTypeKind.USER.name());
    }

    public InputStream getDefinition(MediaType mediaType, String key) {
        Response response = this.getService(mediaType).get(AnyTypeKind.USER.name(), key);
        return (InputStream)response.getEntity();
    }

    public byte[] getDiagram(String key) {
        byte[] diagram;
        WorkflowService service = WorkflowRestClient.getService(WorkflowService.class);
        WebClient.client((Object)service).accept(new String[]{"image/png"});
        Response response = service.exportDiagram(AnyTypeKind.USER.name(), key);
        try {
            diagram = IOUtils.readBytesFromStream((InputStream)((InputStream)response.getEntity()));
        }
        catch (Exception e) {
            LOG.error("Could not get workflow diagram", (Throwable)e);
            diagram = new byte[]{};
        }
        return diagram;
    }

    public void setDefinition(MediaType mediaType, String key, String definition) {
        this.getService(mediaType).set(AnyTypeKind.USER.name(), key, definition);
    }

    public void deleteDefinition(String key) {
        WorkflowRestClient.getService(WorkflowService.class).delete(AnyTypeKind.USER.name(), key);
    }
}

