/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.common.lib.patch.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.StatusPatchType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.common.rest.api.service.UserService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class UserRestClient
extends AbstractAnyRestClient<UserTO> {
    private static final long serialVersionUID = -1575748964398293968L;

    @Override
    protected Class<? extends AnyService<UserTO>> getAnyServiceClass() {
        return UserService.class;
    }

    public ProvisioningResult<UserTO> create(UserTO userTO, boolean storePassword) {
        Response response = UserRestClient.getService(UserService.class).create(userTO, storePassword);
        return (ProvisioningResult)response.readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningResult<UserTO> update(String etag, UserPatch patch) {
        ProvisioningResult result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            result = (ProvisioningResult)UserRestClient.getService(etag, UserService.class).update(patch).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(){});
            UserRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    @Override
    public int count(String realm, String fiql, String type) {
        return UserRestClient.getService(UserService.class).search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm(realm).fiql(fiql).page(Integer.valueOf(1))).size(Integer.valueOf(1))).build()).getTotalCount();
    }

    @Override
    public List<UserTO> search(String realm, String fiql, int page, int size, SortParam<String> sort, String type) {
        return UserRestClient.getService(UserService.class).search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm(realm).fiql(fiql).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(UserRestClient.toOrderBy(sort))).details(false).build()).getResult();
    }

    public ProvisioningResult<UserTO> mustChangePassword(String etag, boolean value, String key) {
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(key);
        userPatch.setMustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)value)).build());
        return this.update(etag, userPatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult suspend(String etag, String userKey, List<StatusBean> statuses) {
        BulkActionResult bulkActionResult;
        StatusPatch statusPatch = StatusUtils.buildStatusPatch(statuses, false);
        statusPatch.setKey(userKey);
        statusPatch.setType(StatusPatchType.SUSPEND);
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            bulkActionResult = new BulkActionResult();
            Map results = bulkActionResult.getResults();
            UserService service = UserRestClient.getService(etag, UserService.class);
            ProvisioningResult provisioningResult = (ProvisioningResult)service.status(statusPatch).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(){});
            if (statusPatch.isOnSyncope()) {
                results.put("syncope", "suspended".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) ? BulkActionResult.Status.SUCCESS : BulkActionResult.Status.FAILURE);
            }
            for (PropagationStatus status : provisioningResult.getPropagationStatuses()) {
                results.put(status.getResource(), BulkActionResult.Status.valueOf((String)status.getStatus().name()));
            }
            UserRestClient.resetClient(UserService.class);
        }
        return bulkActionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult reactivate(String etag, String userKey, List<StatusBean> statuses) {
        BulkActionResult bulkActionResult;
        StatusPatch statusPatch = StatusUtils.buildStatusPatch(statuses, true);
        statusPatch.setKey(userKey);
        statusPatch.setType(StatusPatchType.REACTIVATE);
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            bulkActionResult = new BulkActionResult();
            Map results = bulkActionResult.getResults();
            UserService service = UserRestClient.getService(etag, UserService.class);
            ProvisioningResult provisioningResult = (ProvisioningResult)service.status(statusPatch).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(){});
            if (statusPatch.isOnSyncope()) {
                results.put("syncope", "active".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) ? BulkActionResult.Status.SUCCESS : BulkActionResult.Status.FAILURE);
            }
            for (PropagationStatus status : provisioningResult.getPropagationStatuses()) {
                results.put(status.getResource(), BulkActionResult.Status.valueOf((String)status.getStatus().name()));
            }
            UserRestClient.resetClient(UserService.class);
        }
        return bulkActionResult;
    }
}

