/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import org.apache.syncope.client.console.commons.HttpResourceStream;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ExecutionRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.tasks.ExecutionsDirectoryPanel;
import org.apache.syncope.client.console.wicket.ajax.form.AbstractAjaxDownloadBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.resource.IResourceStream;

public class ReportExecutionDetails
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = -4110576026663173545L;

    public ReportExecutionDetails(ReportTO reportTO, PageReference pageRef) {
        MultilevelPanel mlp = new MultilevelPanel("executions");
        this.add(new Component[]{mlp});
        mlp.setFirstLevel(new ReportExecutionDirectoryPanel(mlp, reportTO.getKey(), new ReportRestClient(), pageRef));
    }

    private static class AjaxExportDownloadBehavior
    extends AbstractAjaxDownloadBehavior {
        private static final long serialVersionUID = 3109256773218160485L;
        private String execution;
        private ReportExecExportFormat exportFormat;
        private HttpResourceStream stream;

        private AjaxExportDownloadBehavior() {
        }

        public AjaxExportDownloadBehavior setDetails(String execution, ReportExecExportFormat exportFormat) {
            this.execution = execution;
            this.exportFormat = exportFormat;
            this.stream = null;
            return this;
        }

        private void createResourceStream() {
            if (this.stream == null) {
                this.stream = new HttpResourceStream(new ReportRestClient().exportExecutionResult(this.execution, this.exportFormat));
            }
        }

        @Override
        protected String getFileName() {
            this.createResourceStream();
            return this.stream == null ? null : this.stream.getFilename();
        }

        @Override
        protected IResourceStream getResourceStream() {
            this.createResourceStream();
            return this.stream;
        }
    }

    private static class ReportExecutionDirectoryPanel
    extends ExecutionsDirectoryPanel {
        private static final long serialVersionUID = 5691719817252887541L;
        private final MultilevelPanel mlp;
        private final AjaxExportDownloadBehavior downloadBehavior;

        ReportExecutionDirectoryPanel(MultilevelPanel multiLevelPanelRef, String key, ExecutionRestClient executionRestClient, PageReference pageRef) {
            super(multiLevelPanelRef, key, executionRestClient, pageRef);
            this.mlp = multiLevelPanelRef;
            this.downloadBehavior = new AjaxExportDownloadBehavior();
            this.add(new Behavior[]{this.downloadBehavior});
        }

        @Override
        protected void next(String title, MultilevelPanel.SecondLevel slevel, AjaxRequestTarget target) {
            this.mlp.next(title, slevel, target);
        }

        @Override
        protected void addFurtherAcions(ActionsPanel<ExecTO> panel, final IModel<ExecTO> model) {
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    ReportExecutionDirectoryPanel.this.downloadBehavior.setDetails(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.CSV);
                    ReportExecutionDirectoryPanel.this.downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_CSV, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    ReportExecutionDirectoryPanel.this.downloadBehavior.setDetails(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.HTML);
                    ReportExecutionDirectoryPanel.this.downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_HTML, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    ReportExecutionDirectoryPanel.this.downloadBehavior.setDetails(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.PDF);
                    ReportExecutionDirectoryPanel.this.downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_PDF, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    ReportExecutionDirectoryPanel.this.downloadBehavior.setDetails(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.RTF);
                    ReportExecutionDirectoryPanel.this.downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_RTF, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    ReportExecutionDirectoryPanel.this.downloadBehavior.setDetails(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.XML);
                    ReportExecutionDirectoryPanel.this.downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_XML, "REPORT_READ");
        }
    }
}

