/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class PolicyModalPanelBuilder<T extends PolicyTO>
extends AbstractModalPanelBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final BaseModal<T> modal;
    private final PolicyType type;
    private final PolicyRestClient restClient = new PolicyRestClient();

    public PolicyModalPanelBuilder(PolicyType type, T policyTO, BaseModal<T> modal, PageReference pageRef) {
        super(policyTO, pageRef);
        this.type = type;
        this.modal = modal;
    }

    @Override
    public WizardModalPanel<T> build(String id, int index, AjaxWizard.Mode mode) {
        return new Profile(this, (PolicyTO)this.newModelObject(), this.modal, this.pageRef);
    }

    public static class Profile
    extends AbstractModalPanel<T> {
        private static final long serialVersionUID = -3043839139187792810L;
        private final T policyTO;
        private final LoadableDetachableModel<List<String>> resources;
        final /* synthetic */ PolicyModalPanelBuilder this$0;

        public Profile(T policyTO, BaseModal<T> modal, PageReference pageRef) {
            this.this$0 = this$0;
            super(modal, pageRef);
            this.resources = new LoadableDetachableModel<List<String>>(){
                private static final long serialVersionUID = 5275935387613157437L;

                protected List<String> load() {
                    return (List)CollectionUtils.collect(new ResourceRestClient().list(), (Transformer)new Transformer<ResourceTO, String>(){

                        public String transform(ResourceTO input) {
                            return input.getKey();
                        }
                    }, new ArrayList());
                }
            };
            modal.setFormModel(policyTO);
            this.policyTO = policyTO;
            ArrayList<AbstractFieldPanel> fields = new ArrayList<AbstractFieldPanel>();
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("field", "description", (IModel<String>)new PropertyModel(policyTO, "description"), false);
            description.setRequired(true);
            fields.add(description);
            if (policyTO instanceof AccountPolicyTO) {
                fields.add(new AjaxSpinnerFieldPanel.Builder<Integer>().build("field", "maxAuthenticationAttempts", Integer.class, (IModel<Integer>)new PropertyModel(policyTO, "maxAuthenticationAttempts")));
                fields.add(new AjaxCheckBoxPanel("field", "propagateSuspension", (IModel<Boolean>)new PropertyModel(policyTO, "propagateSuspension"), false));
                fields.add(new AjaxPalettePanel.Builder().setName("passthroughResources").build("field", new PropertyModel(policyTO, "passthroughResources"), new ListModel((List)this.resources.getObject())));
            }
            if (policyTO instanceof PasswordPolicyTO) {
                fields.add(new AjaxSpinnerFieldPanel.Builder<Integer>().build("field", "historyLength", Integer.class, (IModel<Integer>)new PropertyModel(policyTO, "historyLength")));
                fields.add(new AjaxCheckBoxPanel("field", "allowNullPassword", (IModel<Boolean>)new PropertyModel(policyTO, "allowNullPassword"), false));
            }
            this.add(new Component[]{new ListView<Component>("fields", fields){
                private static final long serialVersionUID = -9180479401817023838L;

                protected void populateItem(ListItem<Component> item) {
                    item.add(new Component[]{(Component)item.getModelObject()});
                }
            }});
        }

        @Override
        public void onSubmit(AjaxRequestTarget target, Form<?> form) {
            try {
                if (this.policyTO.getKey() == null) {
                    this.this$0.restClient.createPolicy(this.this$0.type, this.policyTO);
                } else {
                    this.this$0.restClient.updatePolicy(this.this$0.type, this.policyTO);
                }
                SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                this.modal.close((IPartialPageRequestHandler)target);
            }
            catch (Exception e) {
                LOG.error("While creating/updating policy", (Throwable)e);
                SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
            }
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }
}

