/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.PolicyRenderer;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmDetails
extends Panel {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDetails.class);
    private final PolicyRestClient policyRestClient = new PolicyRestClient();
    private final IModel<Map<String, String>> accountPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            for (PolicyTO policyTO : RealmDetails.this.policyRestClient.getPolicies(PolicyType.ACCOUNT)) {
                res.put(policyTO.getKey(), policyTO.getDescription());
            }
            return res;
        }
    };
    private final IModel<Map<String, String>> passwordPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            for (PolicyTO policyTO : RealmDetails.this.policyRestClient.getPolicies(PolicyType.PASSWORD)) {
                res.put(policyTO.getKey(), policyTO.getDescription());
            }
            return res;
        }
    };
    private final IModel<List<String>> logicActionsClasses = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getLogicActions());
        }
    };
    private final WebMarkupContainer container = new WebMarkupContainer("container");

    public RealmDetails(String id, RealmTO realmTO) {
        this(id, realmTO, null, true);
    }

    public RealmDetails(String id, RealmTO realmTO, ActionsPanel<?> actions, boolean unwrapped) {
        super(id);
        this.container.setOutputMarkupId(true);
        this.container.setRenderBodyOnly(unwrapped);
        this.add(new Component[]{this.container});
        WebMarkupContainer generics = new WebMarkupContainer("generics");
        this.container.add(new Component[]{generics.setVisible(unwrapped)});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel<String>)new PropertyModel((Object)realmTO, "name"), false);
        name.addRequiredLabel();
        generics.add(new Component[]{name});
        AjaxTextFieldPanel fullPath = new AjaxTextFieldPanel("fullPath", "fullPath", (IModel<String>)new PropertyModel((Object)realmTO, "fullPath"), false);
        fullPath.setEnabled(false);
        generics.add(new Component[]{fullPath});
        AjaxDropDownChoicePanel accountPolicy = new AjaxDropDownChoicePanel("accountPolicy", new ResourceModel("accountPolicy", "accountPolicy").getObject(), new PropertyModel((Object)realmTO, "accountPolicy"), false);
        accountPolicy.setChoiceRenderer(new PolicyRenderer(this.accountPolicies));
        accountPolicy.setChoices(new ArrayList(((Map)this.accountPolicies.getObject()).keySet()));
        ((DropDownChoice)accountPolicy.getField()).setNullValid(true);
        this.container.add(new Component[]{accountPolicy});
        AjaxDropDownChoicePanel passwordPolicy = new AjaxDropDownChoicePanel("passwordPolicy", new ResourceModel("passwordPolicy", "passwordPolicy").getObject(), new PropertyModel((Object)realmTO, "passwordPolicy"), false);
        passwordPolicy.setChoiceRenderer(new PolicyRenderer(this.passwordPolicies));
        passwordPolicy.setChoices(new ArrayList(((Map)this.passwordPolicies.getObject()).keySet()));
        ((DropDownChoice)passwordPolicy.getField()).setNullValid(true);
        this.container.add(new Component[]{passwordPolicy});
        AjaxPalettePanel actionsClassNames = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actionsClassNames", new PropertyModel((Object)realmTO, "actionsClassNames"), new ListModel((List)this.logicActionsClasses.getObject()));
        actionsClassNames.setOutputMarkupId(true);
        this.container.add(new Component[]{actionsClassNames});
        this.container.add(new Component[]{new AjaxPalettePanel.Builder().build("resources", new PropertyModel((Object)realmTO, "resources"), new ListModel((List)CollectionUtils.collect(new ResourceRestClient().list(), (Transformer)EntityTOUtils.keyTransformer(), new ArrayList()))).setOutputMarkupId(true).setEnabled(!"/".equals(realmTO.getName())).setVisible(!"/".equals(realmTO.getName()))});
        if (actions == null) {
            this.add(new Component[]{new Fragment("actions", "emptyFragment", (MarkupContainer)this).setRenderBodyOnly(true)});
        } else {
            Fragment fragment = new Fragment("actions", "actionsFragment", (MarkupContainer)this);
            fragment.add(new Component[]{actions});
            this.add(new Component[]{fragment.setRenderBodyOnly(true)});
        }
    }

    public RealmDetails setContentEnabled(boolean enable) {
        this.container.setEnabled(enable);
        return this;
    }
}

