/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security.jws;

import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsVerificationSignature;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.crypto.codec.Base64;

public class AccessTokenJwsSignatureVerifier
implements JwsSignatureVerifier,
InitializingBean {
    private SignatureAlgorithm jwsAlgorithm;
    private String jwsKey;
    private JwsSignatureVerifier delegate;

    public void setJwsAlgorithm(SignatureAlgorithm jwsAlgorithm) {
        this.jwsAlgorithm = jwsAlgorithm;
    }

    public void setJwsKey(String jwsKey) {
        this.jwsKey = jwsKey;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jwsAlgorithm == null) {
            throw new IllegalArgumentException("An instance of " + SignatureAlgorithm.class + " is required");
        }
        if (SignatureAlgorithm.isPublicKeyAlgorithm((SignatureAlgorithm)this.jwsAlgorithm)) {
            if (!this.jwsAlgorithm.getJwaName().startsWith("RS")) {
                throw new IllegalArgumentException(this.jwsAlgorithm.getJavaName() + " not supported.");
            }
            if (this.jwsKey == null || this.jwsKey.indexOf(58) == -1) {
                throw new IllegalArgumentException("A key pair is required, in the 'private:public' format");
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.decode((byte[])StringUtils.substringAfter((String)this.jwsKey, (String)":").getBytes()));
            this.delegate = new PublicKeyJwsSignatureVerifier(kf.generatePublic(keySpecX509), this.jwsAlgorithm);
        } else {
            if (this.jwsKey == null) {
                throw new IllegalArgumentException("A shared key is required");
            }
            this.delegate = new HmacJwsSignatureVerifier(this.jwsKey.getBytes(), this.jwsAlgorithm);
        }
    }

    public SignatureAlgorithm getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        return this.delegate.verify(headers, unsignedText, signature);
    }

    public JwsVerificationSignature createJwsVerificationSignature(JwsHeaders headers) {
        return this.delegate.createJwsVerificationSignature(headers);
    }
}

