/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.commons.text.TextRandomProvider;
import org.apache.syncope.common.lib.SecureTextRandomProvider;

public final class SecureRandomUtils {
    private static final RandomStringGenerator FOR_PASSWORD = new RandomStringGenerator.Builder().usingRandom((TextRandomProvider)new SecureTextRandomProvider()).filteredBy(new CharacterPredicate[]{new CharacterPredicate(){

        public boolean test(int codePoint) {
            return codePoint >= 97 && codePoint <= 122 || codePoint >= 48 && codePoint <= 57;
        }
    }}).build();
    private static final RandomStringGenerator FOR_LETTERS = new RandomStringGenerator.Builder().usingRandom((TextRandomProvider)new SecureTextRandomProvider()).withinRange(97, 122).build();
    private static final RandomStringGenerator FOR_NUMBERS = new RandomStringGenerator.Builder().usingRandom((TextRandomProvider)new SecureTextRandomProvider()).withinRange(48, 57).build();

    public static String generateRandomPassword(int tokenLength) {
        return FOR_PASSWORD.generate(tokenLength);
    }

    public static String generateRandomLetter() {
        return FOR_LETTERS.generate(1);
    }

    public static String generateRandomNumber() {
        return FOR_NUMBERS.generate(1);
    }

    public static String generateRandomSpecialCharacter(final char[] characters) {
        return new RandomStringGenerator.Builder().usingRandom((TextRandomProvider)new SecureTextRandomProvider()).filteredBy(new CharacterPredicate[]{new CharacterPredicate(){

            public boolean test(int codePoint) {
                boolean found = false;
                for (int i = 0; i < characters.length && !found; ++i) {
                    found = codePoint == Character.codePointAt(characters, i);
                }
                return found;
            }
        }}).build().generate(1);
    }

    private SecureRandomUtils() {
    }
}

