/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetailsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class JWTAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationManager authenticationManager;
    private SyncopeAuthenticationDetailsSource authenticationDetailsSource;
    @Autowired
    private AuthDataAccessor dataAccessor;
    @Autowired
    private DefaultCredentialChecker credentialChecker;

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDetailsSource(SyncopeAuthenticationDetailsSource authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"An AuthenticationEntryPoint is required");
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Assert.notNull((Object)this.authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String[] parts;
        String auth = request.getHeader("Authorization");
        String[] stringArray = parts = auth == null ? null : auth.split(" ");
        if (parts == null || parts.length != 2 || !"Bearer".equals(parts[0])) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String stringToken = parts[1];
        LOG.debug("JWT received: {}", (Object)stringToken);
        try {
            this.credentialChecker.checkIsDefaultJWSKeyInUse();
            JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(stringToken);
            JWTSSOProvider jwtSSOProvider = this.dataAccessor.getJWTSSOProvider(consumer.getJwtClaims().getIssuer());
            if (!consumer.verifySignatureWith((JwsSignatureVerifier)jwtSSOProvider)) {
                throw new BadCredentialsException("Invalid signature found in JWT");
            }
            Authentication authentication = this.authenticationManager.authenticate((Authentication)new JWTAuthentication(consumer.getJwtClaims(), this.authenticationDetailsSource.buildDetails(request)));
            SecurityContextHolder.getContext().setAuthentication(authentication);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (JwsException e) {
            SecurityContextHolder.clearContext();
            this.authenticationEntryPoint.commence(request, response, (AuthenticationException)new BadCredentialsException("Invalid JWT: " + stringToken, (Throwable)e));
        }
        catch (AuthenticationException e) {
            SecurityContextHolder.clearContext();
            this.authenticationEntryPoint.commence(request, response, e);
        }
    }
}

