/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCProviderDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.OIDCEntityFactory;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCProviderItem;
import org.apache.syncope.core.persistence.api.entity.OIDCUserTemplate;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.data.OIDCProviderDataBinder;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.apache.syncope.core.spring.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OIDCProviderDataBinderImpl
implements OIDCProviderDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(OIDCProviderDataBinder.class);
    private static final String[] ITEM_IGNORE_PROPERTIES = new String[]{"key", "purpose"};
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private OIDCProviderDAO oidcOPDAO;
    @Autowired
    private OIDCEntityFactory entityFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public OIDCProvider create(OIDCProviderTO opTO) {
        return this.update((OIDCProvider)this.entityFactory.newEntity(OIDCProvider.class), opTO);
    }

    private void populateItems(OIDCProviderTO opTO, OIDCProvider op, AnyTypeClassTO allowedSchemas) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        for (ItemTO itemTO : opTO.getItems()) {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)ItemTO.class.getSimpleName());
                invalidMapping.getElements().add("Null " + ItemTO.class.getSimpleName());
                continue;
            }
            if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
                continue;
            }
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(itemTO.getIntAttrName(), AnyTypeKind.USER);
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)itemTO.getIntAttrName(), (Object)e);
            }
            if (intAttrName == null || intAttrName.getSchemaType() == null && intAttrName.getField() == null) {
                LOG.error("'{}' not existing", (Object)itemTO.getIntAttrName());
                invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not existing");
                continue;
            }
            boolean allowed = true;
            if (intAttrName.getSchemaType() != null && intAttrName.getEnclosingGroup() == null && intAttrName.getRelatedAnyObject() == null) {
                switch (intAttrName.getSchemaType()) {
                    case PLAIN: {
                        allowed = allowedSchemas.getPlainSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                    case DERIVED: {
                        allowed = allowedSchemas.getDerSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                    case VIRTUAL: {
                        allowed = allowedSchemas.getVirSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                }
            }
            if (allowed) {
                if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
                    SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                    invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                    scce.addException(invalidMandatoryCondition);
                }
                OIDCProviderItem item = (OIDCProviderItem)this.entityFactory.newEntity(OIDCProviderItem.class);
                BeanUtils.copyProperties((Object)itemTO, (Object)item, (String[])ITEM_IGNORE_PROPERTIES);
                item.setOP(op);
                item.setPurpose(MappingPurpose.NONE);
                if (item.isConnObjectKey()) {
                    if (intAttrName.getSchemaType() == SchemaType.VIRTUAL) {
                        invalidMapping.getElements().add("Virtual attributes cannot be set as ConnObjectKey");
                    }
                    if ("password".equals(intAttrName.getField())) {
                        invalidMapping.getElements().add("Password attributes cannot be set as ConnObjectKey");
                    }
                    op.setConnObjectKeyItem(item);
                    continue;
                }
                op.add(item);
                continue;
            }
            LOG.error("'{}' not allowed", (Object)itemTO.getIntAttrName());
            invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not allowed");
        }
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public OIDCProvider update(OIDCProvider op, OIDCProviderTO opTO) {
        op.setAuthorizationEndpoint(opTO.getAuthorizationEndpoint());
        op.setClientID(opTO.getClientID());
        op.setClientSecret(opTO.getClientSecret());
        op.setName(opTO.getName());
        op.setIssuer(opTO.getIssuer());
        op.setJwksUri(opTO.getJwksUri());
        op.setTokenEndpoint(opTO.getTokenEndpoint());
        op.setUserinfoEndpoint(opTO.getUserinfoEndpoint());
        op.setEndSessionEndpoint(opTO.getEndSessionEndpoint());
        op.setHasDiscovery(opTO.getHasDiscovery());
        op.setCreateUnmatching(opTO.isCreateUnmatching());
        op.setSelfRegUnmatching(opTO.isSelfRegUnmatching());
        op.setUpdateMatching(opTO.isUpdateMatching());
        if (opTO.getUserTemplate() == null) {
            op.setUserTemplate(null);
        } else {
            OIDCUserTemplate userTemplate = op.getUserTemplate();
            if (userTemplate == null) {
                userTemplate = (OIDCUserTemplate)this.entityFactory.newEntity(OIDCUserTemplate.class);
                userTemplate.setAnyType(this.anyTypeDAO.findUser());
                userTemplate.setOP(op);
                op.setUserTemplate(userTemplate);
            }
            userTemplate.set((AnyTO)opTO.getUserTemplate());
        }
        op.getItems().clear();
        AnyTypeClassTO allowedSchemas = new AnyTypeClassTO();
        for (AnyTypeClass anyTypeClass : this.anyTypeDAO.findUser().getClasses()) {
            allowedSchemas.getPlainSchemas().addAll(CollectionUtils.collect((Iterable)anyTypeClass.getPlainSchemas(), (Transformer)EntityUtils.keyTransformer()));
            allowedSchemas.getDerSchemas().addAll(CollectionUtils.collect((Iterable)anyTypeClass.getDerSchemas(), (Transformer)EntityUtils.keyTransformer()));
            allowedSchemas.getVirSchemas().addAll(CollectionUtils.collect((Iterable)anyTypeClass.getVirSchemas(), (Transformer)EntityUtils.keyTransformer()));
        }
        this.populateItems(opTO, op, allowedSchemas);
        op.getActionsClassNames().clear();
        op.getActionsClassNames().addAll(opTO.getActionsClassNames());
        return this.oidcOPDAO.save(op);
    }

    private void populateItems(OIDCProvider op, OIDCProviderTO opTO) {
        for (OIDCProviderItem item : op.getItems()) {
            ItemTO itemTO = new ItemTO();
            itemTO.setKey(item.getKey());
            BeanUtils.copyProperties((Object)item, (Object)itemTO, (String[])ITEM_IGNORE_PROPERTIES);
            itemTO.setPurpose(MappingPurpose.NONE);
            if (itemTO.isConnObjectKey()) {
                opTO.setConnObjectKeyItem(itemTO);
                continue;
            }
            opTO.add(itemTO);
        }
    }

    public OIDCProviderTO getOIDCProviderTO(OIDCProvider op) {
        OIDCProviderTO opTO = new OIDCProviderTO();
        opTO.setKey(op.getKey());
        opTO.setAuthorizationEndpoint(op.getAuthorizationEndpoint());
        opTO.setClientID(op.getClientID());
        opTO.setClientSecret(op.getClientSecret());
        opTO.setName(op.getName());
        opTO.setIssuer(op.getIssuer());
        opTO.setJwksUri(op.getJwksUri());
        opTO.setTokenEndpoint(op.getTokenEndpoint());
        opTO.setUserinfoEndpoint(op.getUserinfoEndpoint());
        opTO.setEndSessionEndpoint(op.getEndSessionEndpoint());
        opTO.setHasDiscovery(op.getHasDiscovery());
        opTO.setCreateUnmatching(op.isCreateUnmatching());
        opTO.setSelfRegUnmatching(op.isSelfRegUnmatching());
        opTO.setUpdateMatching(op.isUpdateMatching());
        if (op.getUserTemplate() != null) {
            opTO.setUserTemplate((UserTO)op.getUserTemplate().get());
        }
        this.populateItems(op, opTO);
        opTO.getActionsClassNames().addAll(op.getActionsClassNames());
        return opTO;
    }
}

