/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TemplateUtils {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;

    private AttrTO evaluateAttr(AttrTO template, MapContext jexlContext) {
        AttrTO result = new AttrTO();
        result.setSchema(template.getSchema());
        if (template.getValues() != null && !template.getValues().isEmpty()) {
            for (String value : template.getValues()) {
                String evaluated = JexlUtils.evaluate(value, (JexlContext)jexlContext);
                if (!StringUtils.isNotBlank((CharSequence)evaluated)) continue;
                result.getValues().add(evaluated);
            }
        }
        return result;
    }

    private void fill(AnyTO anyTO, AnyTO template) {
        AttrTO evaluated;
        String evaluated2;
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext(anyTO, (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getVirAttrs(), (JexlContext)jexlContext);
        if (template.getRealm() != null && StringUtils.isNotBlank((CharSequence)(evaluated2 = JexlUtils.evaluate(template.getRealm(), (JexlContext)jexlContext)))) {
            anyTO.setRealm(evaluated2);
        }
        Map currentAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getPlainAttrs());
        for (AttrTO templatePlainAttr : template.getPlainAttrs()) {
            if (templatePlainAttr.getValues().isEmpty() || currentAttrMap.containsKey(templatePlainAttr.getSchema()) && !((AttrTO)currentAttrMap.get(templatePlainAttr.getSchema())).getValues().isEmpty() || (evaluated = this.evaluateAttr(templatePlainAttr, jexlContext)).getValues().isEmpty()) continue;
            anyTO.getPlainAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getDerAttrs());
        for (AttrTO templateDerAttr : template.getDerAttrs()) {
            if (currentAttrMap.containsKey(templateDerAttr.getSchema())) continue;
            anyTO.getDerAttrs().add(templateDerAttr);
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getVirAttrs());
        for (AttrTO templateVirAttr : template.getVirAttrs()) {
            if (templateVirAttr.getValues().isEmpty() || currentAttrMap.containsKey(templateVirAttr.getSchema()) && !((AttrTO)currentAttrMap.get(templateVirAttr.getSchema())).getValues().isEmpty() || (evaluated = this.evaluateAttr(templateVirAttr, jexlContext)).getValues().isEmpty()) continue;
            anyTO.getVirAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        anyTO.getResources().addAll(template.getResources());
        anyTO.getAuxClasses().addAll(template.getAuxClasses());
    }

    private void fillRelationships(GroupableRelatableTO any, GroupableRelatableTO template) {
        for (RelationshipTO relationship : template.getRelationships()) {
            if (any.getRelationship(relationship.getType(), relationship.getOtherEndKey()) != null) continue;
            any.getRelationships().add(relationship);
        }
    }

    private void fillMemberships(GroupableRelatableTO any, GroupableRelatableTO template) {
        for (MembershipTO membership : template.getMemberships()) {
            if (any.getMembership(membership.getGroupKey()) != null) continue;
            any.getMemberships().add(membership);
        }
    }

    @Transactional(readOnly=true)
    public <T extends AnyTO> void apply(T anyTO, AnyTemplate anyTemplate) {
        if (anyTemplate != null) {
            this.apply(anyTO, anyTemplate.get());
        }
    }

    @Transactional(readOnly=true)
    public <T extends AnyTO> void apply(T anyTO, AnyTO template) {
        this.fill(anyTO, template);
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext(anyTO, (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getVirAttrs(), (JexlContext)jexlContext);
        if (template instanceof AnyObjectTO) {
            this.fillRelationships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
            this.fillMemberships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
        } else if (template instanceof UserTO) {
            String evaluated;
            if (StringUtils.isNotBlank((CharSequence)((UserTO)template).getUsername()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate(((UserTO)template).getUsername(), (JexlContext)jexlContext)))) {
                ((UserTO)anyTO).setUsername(evaluated);
            }
            if (StringUtils.isNotBlank((CharSequence)((UserTO)template).getPassword()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate(((UserTO)template).getPassword(), (JexlContext)jexlContext)))) {
                ((UserTO)anyTO).setPassword(evaluated);
            }
            this.fillRelationships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
            this.fillMemberships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
            ((UserTO)anyTO).getRoles().addAll(((UserTO)template).getRoles());
        } else if (template instanceof GroupTO) {
            Group groupOwner;
            User userOwner;
            String evaluated;
            if (StringUtils.isNotBlank((CharSequence)((GroupTO)template).getName()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate(((GroupTO)template).getName(), (JexlContext)jexlContext)))) {
                ((GroupTO)anyTO).setName(evaluated);
            }
            if (((GroupTO)template).getUserOwner() != null && (userOwner = (User)this.userDAO.find(((GroupTO)template).getUserOwner())) != null) {
                ((GroupTO)anyTO).setUserOwner(userOwner.getKey());
            }
            if (((GroupTO)template).getGroupOwner() != null && (groupOwner = (Group)this.groupDAO.find(((GroupTO)template).getGroupOwner())) != null) {
                ((GroupTO)anyTO).setGroupOwner(groupOwner.getKey());
            }
        }
    }

    public void check(Map<String, AnyTO> templates, ClientExceptionType clientExceptionType) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)clientExceptionType);
        for (Map.Entry<String, AnyTO> entry : templates.entrySet()) {
            UserTO template;
            for (AttrTO attrTO : entry.getValue().getPlainAttrs()) {
                if (attrTO.getValues().isEmpty() || JexlUtils.isExpressionValid((String)attrTO.getValues().get(0))) continue;
                sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0));
            }
            for (AttrTO attrTO : entry.getValue().getVirAttrs()) {
                if (attrTO.getValues().isEmpty() || JexlUtils.isExpressionValid((String)attrTO.getValues().get(0))) continue;
                sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0));
            }
            if (entry.getValue() instanceof UserTO) {
                template = (UserTO)entry.getValue();
                if (StringUtils.isNotBlank((CharSequence)template.getUsername()) && !JexlUtils.isExpressionValid(template.getUsername())) {
                    sce.getElements().add("Invalid JEXL: " + template.getUsername());
                }
                if (!StringUtils.isNotBlank((CharSequence)template.getPassword()) || JexlUtils.isExpressionValid(template.getPassword())) continue;
                sce.getElements().add("Invalid JEXL: " + template.getPassword());
                continue;
            }
            if (!(entry.getValue() instanceof GroupTO) || !StringUtils.isNotBlank((CharSequence)(template = (GroupTO)entry.getValue()).getName()) || JexlUtils.isExpressionValid(template.getName())) continue;
            sce.getElements().add("Invalid JEXL: " + template.getName());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
    }
}

