/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.job.SetUMembershipsJob;
import org.apache.syncope.core.provisioning.java.pushpull.PullUtils;
import org.apache.syncope.core.provisioning.java.pushpull.SchedulingPullActions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LDAPMembershipPullActions
extends SchedulingPullActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipPullActions.class);
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    private PullUtils pullUtils;
    protected final Map<String, Set<String>> membershipsBefore = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> membershipsAfter = new HashMap<String, Set<String>>();

    protected String getGroupMembershipAttrName(Connector connector) {
        ConnConfProperty groupMembership = (ConnConfProperty)IterableUtils.find((Iterable)connector.getConnInstance().getConf(), (Predicate)new Predicate<ConnConfProperty>(){

            public boolean evaluate(ConnConfProperty property) {
                return "groupMemberAttribute".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty();
            }
        });
        return groupMembership == null ? "uniquemember" : (String)groupMembership.getValues().get(0);
    }

    protected List<Object> getMembAttrValues(SyncDelta delta, Connector connector) {
        List result = Collections.emptyList();
        String groupMemberName = this.getGroupMembershipAttrName(connector);
        Attribute membAttr = delta.getObject().getAttributeByName(groupMemberName);
        if (membAttr == null) {
            OperationOptionsBuilder oob = new OperationOptionsBuilder();
            oob.setAttributesToGet(new String[]{groupMemberName});
            ConnectorObject remoteObj = connector.getObject(ObjectClass.GROUP, (Attribute)delta.getUid(), oob.build());
            if (remoteObj == null) {
                LOG.debug("Object for '{}' not found", (Object)delta.getUid().getUidValue());
            } else {
                membAttr = remoteObj.getAttributeByName(groupMemberName);
            }
        }
        if (membAttr != null && membAttr.getValue() != null) {
            result = membAttr.getValue();
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public <P extends AnyPatch> void beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, P anyPatch) throws JobExecutionException {
        if (!(entity instanceof GroupTO)) {
            super.beforeUpdate(profile, delta, entity, anyPatch);
        }
        for (UMembership uMembership : this.groupDAO.findUMemberships((Group)this.groupDAO.find(entity.getKey()))) {
            Set<String> memb = this.membershipsBefore.get(((User)uMembership.getLeftEnd()).getKey());
            if (memb == null) {
                memb = new HashSet<String>();
                this.membershipsBefore.put(((User)uMembership.getLeftEnd()).getKey(), memb);
            }
            memb.add(entity.getKey());
        }
    }

    @Override
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        if (!(profile.getTask() instanceof PullTask)) {
            return;
        }
        if (!(entity instanceof GroupTO) || profile.getTask().getResource().getProvision(this.anyTypeDAO.findUser()) == null || profile.getTask().getResource().getProvision(this.anyTypeDAO.findUser()).getMapping() == null) {
            super.after(profile, delta, entity, result);
        }
        for (Object membValue : this.getMembAttrValues(delta, profile.getConnector())) {
            String userKey = this.pullUtils.match(this.anyTypeDAO.findUser(), membValue.toString(), profile.getTask().getResource(), profile.getConnector());
            if (userKey == null) {
                LOG.warn("Could not find matching user for {}", membValue);
                continue;
            }
            Set<String> memb = this.membershipsAfter.get(userKey);
            if (memb == null) {
                memb = new HashSet<String>();
                this.membershipsAfter.put(userKey, memb);
            }
            memb.add(entity.getKey());
        }
    }

    @Override
    public void afterAll(ProvisioningProfile<?, ?> profile) throws JobExecutionException {
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put("membershipsBefore", this.membershipsBefore);
        jobMap.put("membershipsAfter", this.membershipsAfter);
        this.schedule(SetUMembershipsJob.class, jobMap);
    }
}

